/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.energy;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;

public class BaseEnergyStorage
implements UniversalEnergyStorage {
    protected int energy;
    protected final int capacity;
    protected final int maxReceive;
    protected final int maxExtract;

    public BaseEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = 0;
    }

    public BaseEnergyStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public void setEnergyStored(int energy) {
        this.energy = Math.clamp((long)energy, 0, this.getMaxEnergy());
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return this.capacity;
    }

    @Override
    public int insert(int amount, boolean simulate) {
        if (amount < 0) {
            return this.extract(-amount, simulate);
        }
        if (!this.canInsertEnergy()) {
            return 0;
        }
        int toReceive = Math.clamp((long)(this.capacity - this.getEnergy()), 0, Math.min(this.maxReceive, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() + toReceive);
        }
        return toReceive;
    }

    @Override
    public int extract(int amount, boolean simulate) {
        if (amount < 0) {
            return this.insert(-amount, simulate);
        }
        if (!this.canExtractEnergy()) {
            return 0;
        }
        int toExtract = Math.min(this.getEnergy(), Math.min(this.maxExtract, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() - toExtract);
        }
        return toExtract;
    }

    public int insertWithoutLimits(int amount, boolean simulate) {
        int toReceive = Math.clamp((long)(this.capacity - this.getEnergy()), 0, amount);
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() + toReceive);
        }
        return toReceive;
    }

    public int extractWithoutLimits(int amount, boolean simulate) {
        int toExtract = Math.min(this.getEnergy(), amount);
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() - toExtract);
        }
        return toExtract;
    }

    @Override
    public boolean canInsertEnergy() {
        return this.maxReceive > 0;
    }

    @Override
    public boolean canExtractEnergy() {
        return this.maxExtract > 0;
    }
}

