/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fabric.fluid;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class UniversalFluidVariantStorage
implements UniversalFluidStorage {
    protected final Storage<FluidVariant> storage;

    public UniversalFluidVariantStorage(Storage<FluidVariant> storage) {
        this.storage = storage;
    }

    @Override
    public int getTanks() {
        int i = 0;
        Storage<FluidVariant> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            return slottedStorage.getSlotCount();
        }
        for (StorageView ignored : this.storage) {
            ++i;
        }
        return i;
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        Storage<FluidVariant> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            return FluidStackHooksFabric.fromFabric((FluidVariant)((FluidVariant)slottedStorage.getSlot(tank).getResource()), (long)(slottedStorage.getSlot(tank).getAmount() / 81L));
        }
        int i = 0;
        for (StorageView view : this.storage) {
            if (i == tank) {
                return FluidStackHooksFabric.fromFabric((FluidVariant)((FluidVariant)view.getResource()), (long)(view.getAmount() / 81L));
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(tank);
    }

    @Override
    public long getTankCapacity(int tank) {
        Storage<FluidVariant> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            return slottedStorage.getSlot(tank).getCapacity() / 81L;
        }
        int i = 0;
        for (StorageView view : this.storage) {
            if (i == tank) {
                return view.getCapacity() / 81L;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(tank);
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public long fill(FluidStack stack, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long amount = this.storage.insert((Object)FluidStackHooksFabric.toFabric((FluidStack)stack), stack.getAmount() * 81L, (TransactionContext)transaction) / 81L;
            if (simulate || amount == 0L) {
                transaction.close();
            } else {
                transaction.commit();
            }
            long l = amount;
            return l;
        }
    }

    @Override
    public FluidStack drain(FluidStack stack, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long amount = this.storage.extract((Object)FluidStackHooksFabric.toFabric((FluidStack)stack), stack.getAmount() * 81L, (TransactionContext)transaction) / 81L;
            if (simulate || amount == 0L) {
                transaction.close();
            } else {
                transaction.commit();
            }
            FluidStack fluidStack = FluidStack.create((FluidStack)stack, (long)amount);
            return fluidStack;
        }
    }

    @Override
    @NotNull
    public Iterator<FluidStack> iterator() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (StorageView storageView : this.storage) {
            fluidStacks.add(FluidStackHooksFabric.fromFabric((FluidVariant)((FluidVariant)storageView.getResource()), (long)(storageView.getAmount() / 81L)));
        }
        return fluidStacks.iterator();
    }
}

