/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TexturedButton
extends class_4185 {
    public static final class_2960 TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    public static final class_2960 HOVER_TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    private class_2960 buttonTexture;
    private class_2960 hoverButtonTexture;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private int textureWidth;
    private int textureHeight;
    private boolean showText = false;
    private boolean showTooltip = false;

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, class_4185.class_4241 onPressIn) {
        this(xIn, yIn, widthIn, heightIn, (class_2561)class_2561.method_43473(), onPressIn, field_40754);
    }

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn) {
        this(xIn, yIn, widthIn, heightIn, title, onPressIn, field_40754);
    }

    public TexturedButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn, class_4185.class_7841 onTooltipIn) {
        super(xIn, yIn, widthIn, heightIn, title, onPressIn, onTooltipIn);
        this.textureWidth = widthIn;
        this.textureHeight = heightIn;
        this.yDiffText = 0;
        this.xTexStart = 0;
        this.yTexStart = 0;
        this.buttonTexture = TEXTURE;
        this.hoverButtonTexture = HOVER_TEXTURE;
    }

    public <T extends TexturedButton> T tooltip(@Nullable class_7919 tooltip) {
        this.method_47400(tooltip);
        return this.cast();
    }

    private <T extends TexturedButton> T cast() {
        return (T)((Object)this);
    }

    public <T extends TexturedButton> T tex(class_2960 buttonTexture, class_2960 hoverTexture) {
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hoverTexture;
        return this.cast();
    }

    public <T extends TexturedButton> T size(int texWidth, int texHeight) {
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        return this.cast();
    }

    public <T extends TexturedButton> T setUVs(int xTexStart, int yTexStart) {
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        return this.cast();
    }

    public <T extends TexturedButton> T showText(boolean showText) {
        this.showText = showText;
        return this.cast();
    }

    public <T extends TexturedButton> T showTooltip(boolean showTooltip) {
        this.showTooltip = showTooltip;
        return this.cast();
    }

    public void method_47400(@Nullable class_7919 tooltip) {
        super.method_47400(tooltip);
    }

    public void setYShift(int y) {
        this.yDiffText = y;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int color;
        class_310 minecraft = class_310.method_1551();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        int i = this.yTexStart;
        if (this.method_25367()) {
            i += this.yDiffText;
            if (this.showTooltip) {
                graphics.method_51447(minecraft.field_1772, this.method_51254().method_47405(class_310.method_1551()), mouseX, mouseY);
            }
        }
        class_2960 texture = this.getTypeTexture(this.field_22762, this.buttonTexture, this.hoverButtonTexture);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        ScreenHelper.renderTextureWithColor.blit(graphics.method_51448(), this.method_46426(), this.method_46427(), this.xTexStart, i, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight, this.getTypeColor());
        int n = color = this.field_22762 ? 0xFFFFFF : 0xA0A0A0;
        if (this.showText) {
            this.method_48589(graphics, minecraft.field_1772, color | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    private class_2960 getTypeTexture(boolean hover, class_2960 buttonTexture, class_2960 hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    public void method_55445(int width, int height) {
        super.method_55445(width, height);
        this.textureWidth = width;
        this.textureHeight = height;
    }

    protected class_243 getTypeColor() {
        return ColorTypes.DEFAULT.getColor();
    }

    public static enum ColorTypes {
        DEFAULT(new class_243(255.0, 255.0, 255.0)),
        WHITE(new class_243(240.0, 240.0, 240.0)),
        ORANGE(new class_243(235.0, 136.0, 68.0)),
        MAGENTA(new class_243(195.0, 84.0, 205.0)),
        LIGHT_BLUE(new class_243(102.0, 137.0, 211.0)),
        YELLOW(new class_243(222.0, 207.0, 42.0)),
        LIME(new class_243(65.0, 205.0, 52.0)),
        PINK(new class_243(216.0, 129.0, 152.0)),
        GRAY(new class_243(67.0, 67.0, 67.0)),
        LIGHT_GRAY(new class_243(171.0, 171.0, 171.0)),
        CYAN(new class_243(40.0, 118.0, 151.0)),
        PURPLE(new class_243(123.0, 47.0, 190.0)),
        BLUE(new class_243(37.0, 49.0, 146.0)),
        BROWN(new class_243(81.0, 48.0, 26.0)),
        GREEN(new class_243(53.0, 163.0, 79.0)),
        RED(new class_243(179.0, 49.0, 44.0)),
        BLACK(new class_243(30.0, 27.0, 27.0));

        private final class_243 color;

        private ColorTypes(class_243 color) {
            this.color = color;
        }

        public class_243 getColor() {
            return this.color;
        }
    }
}

