/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.data_components.JetSuitComponent;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9331;

public class JetSuit {

    public static enum ModeType implements class_3542
    {
        DISABLED((class_2561)class_2561.method_43471((String)"general.stellaris.jet_suit_disabled_mode"), class_124.field_1061, 0),
        NORMAL((class_2561)class_2561.method_43471((String)"general.stellaris.jet_suit_normal_mode"), class_124.field_1060, 1),
        HOVER((class_2561)class_2561.method_43471((String)"general.stellaris.jet_suit_hover_mode"), class_124.field_1060, 2),
        ELYTRA((class_2561)class_2561.method_43471((String)"general.stellaris.jet_suit_elytra_mode"), class_124.field_1060, 3),
        CREATIVE((class_2561)class_2561.method_43471((String)"general.stellaris.jet_suit_creative_mode"), class_124.field_1060, 4);

        private final int mode;
        private final class_124 chatFormatting;
        private final class_2561 component;
        public static final Codec<ModeType> CODEC;

        private ModeType(class_2561 component, class_124 chatFormatting, int mode) {
            this.mode = mode;
            this.chatFormatting = chatFormatting;
            this.component = component;
        }

        public class_124 getChatFormatting() {
            return this.chatFormatting;
        }

        public class_2561 getComponent() {
            return this.component;
        }

        public int getMode() {
            return this.mode;
        }

        public String method_15434() {
            return String.valueOf(this.mode);
        }

        public static ModeType fromInt(int integer) {
            return ModeType.fromString(Integer.toString(integer));
        }

        public static ModeType fromString(String string) {
            return switch (Integer.decode(string)) {
                case 1 -> NORMAL;
                case 2 -> HOVER;
                case 3 -> ELYTRA;
                case 4 -> CREATIVE;
                default -> DISABLED;
            };
        }

        static {
            CODEC = class_3542.method_28140(ModeType::values);
        }
    }

    public static class Suit
    extends AbstractSpaceArmor.Chestplate {
        public float spacePressTime = 0.0f;
        private int nextFuelCheckTick = 0;

        public Suit(class_6880<class_1741> material, class_1792.class_1793 properties) {
            super(material, class_1738.class_8051.field_41935, properties, false);
        }

        public int getMode(class_1799 itemStack) {
            return ((JetSuitComponent)itemStack.method_57824((class_9331)DataComponentsRegistry.JET_SUIT_COMPONENT.get())).type().getMode();
        }

        public ModeType getModeType(class_1799 itemStack) {
            return switch (this.getMode(itemStack)) {
                case 1 -> ModeType.NORMAL;
                case 2 -> ModeType.HOVER;
                case 3 -> ModeType.ELYTRA;
                default -> ModeType.DISABLED;
            };
        }

        public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
            class_1657 player;
            super.method_7888(stack, level, entity, slotId, isSelected);
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_6118(class_1304.field_6174).method_7909() instanceof Suit) {
                class_1799 jetSuitItemStack = player.method_6118(class_1304.field_6174);
                if (player.method_5624()) {
                    this.boost(player, 1.3, true);
                }
                if (player.field_6250 > 0.0f && !player.method_5624()) {
                    this.boost(player, 0.9, false);
                }
                switch (this.getMode(stack)) {
                    case 1: {
                        this.normalFlyModeMovement(player, jetSuitItemStack);
                        break;
                    }
                    case 2: {
                        this.hoverModeMovement(player, jetSuitItemStack);
                        break;
                    }
                    case 3: {
                        this.elytraModeMovement(player, jetSuitItemStack);
                    }
                }
                this.calculateSpacePressTime(player, jetSuitItemStack);
            }
        }

        private void normalFlyModeMovement(class_1657 player, class_1799 stack) {
            if (!player.method_31549().field_7479 && !player.method_5765() && Utils.isLivingInJetSuit((class_1309)player) && this.getMode(stack) == ModeType.NORMAL.getMode() && !player.method_6059(class_1294.field_5906)) {
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (KeyVariables.isHoldingJump(player)) {
                    if (this.nextFuelCheckTick > 0) {
                        player.method_5724(1.2f, new class_243(0.0, 0.1, 0.0));
                        player.method_38785();
                        Utils.disableFlyAntiCheat(player, true);
                    } else if (storage.getFluidInTank(1).isEmpty()) {
                        player.method_5724(1.2f, new class_243(0.0, 0.1, 0.0));
                        player.method_38785();
                        Utils.disableFlyAntiCheat(player, true);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                    if (!player.method_24828()) {
                        class_243 movement = class_243.field_1353;
                        if (KeyVariables.isHoldingUp(player)) {
                            movement = movement.method_1019(player.method_5720().method_1021(0.1));
                        }
                        if (KeyVariables.isHoldingDown(player)) {
                            movement = movement.method_1019(player.method_5720().method_1021(-0.05));
                        }
                        if (KeyVariables.isHoldingLeft(player)) {
                            movement = movement.method_1019(class_243.method_1030((float)0.0f, (float)(player.method_36454() - 90.0f)).method_1021(0.1));
                        }
                        if (KeyVariables.isHoldingRight(player)) {
                            movement = movement.method_1019(class_243.method_1030((float)0.0f, (float)(player.method_36454() + 90.0f)).method_1021(0.1));
                        }
                        player.method_18799(player.method_18798().method_1019(movement));
                    }
                    if (!player.method_37908().field_9236) {
                        class_243 look = player.method_5720();
                        class_3218 serverLevel = (class_3218)player.method_37908();
                        class_243 particlePos = player.method_19538().method_1020(look.method_1021(0.75)).method_1031(0.0, 0.25, 0.0);
                        serverLevel.method_14199((class_2394)class_2398.field_17909, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.15, 0.15, 0.15, 0.05);
                    }
                }
            }
        }

        private void hoverModeMovement(class_1657 player, class_1799 stack) {
            if (!player.method_31549().field_7479 && !player.method_5765() && Utils.isLivingInJetSuit((class_1309)player) && this.getMode(stack) == ModeType.HOVER.getMode() && !player.method_6059(class_1294.field_5906)) {
                class_243 vec3 = player.method_18798();
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (!player.method_24828() && !player.method_5799()) {
                    if (this.nextFuelCheckTick > 0) {
                        player.method_18800(vec3.field_1352, vec3.field_1351 + 0.04, vec3.field_1350);
                        player.method_38785();
                        Utils.disableFlyAntiCheat(player, true);
                    } else if (!storage.getFluidInTank(1).isEmpty()) {
                        player.method_18800(vec3.field_1352, vec3.field_1351 + 0.04, vec3.field_1350);
                        player.method_38785();
                        Utils.disableFlyAntiCheat(player, true);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                }
                if (KeyVariables.isHoldingJump(player)) {
                    Utils.disableFlyAntiCheat(player, true);
                    if (player.method_18276()) {
                        player.method_5724(0.05f, new class_243(0.0, -0.08, 0.0));
                    }
                    if (!player.method_24828()) {
                        if (KeyVariables.isHoldingUp(player)) {
                            player.method_5724(0.1f, new class_243(0.0, 0.0, 0.1));
                        } else if (KeyVariables.isHoldingDown(player)) {
                            player.method_5724(0.1f, new class_243(0.0, 0.0, -0.1));
                        }
                    }
                    if (!player.method_24828()) {
                        if (KeyVariables.isHoldingRight(player)) {
                            player.method_5724(0.1f, new class_243(-0.1, 0.0, 0.0));
                        } else if (KeyVariables.isHoldingLeft(player)) {
                            player.method_5724(0.1f, new class_243(0.1, 0.0, 0.0));
                        }
                    }
                    if (!player.method_37908().field_9236) {
                        class_243 look = player.method_5720();
                        class_3218 serverLevel = (class_3218)player.method_37908();
                        class_243 particlePos = player.method_19538().method_1020(look.method_1021(0.75)).method_1031(0.0, 0.25, 0.0);
                        serverLevel.method_14199((class_2394)class_2398.field_17909, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.15, 0.15, 0.15, 0.05);
                    }
                }
            }
        }

        private void elytraModeMovement(class_1657 player, class_1799 stack) {
            if (!player.method_31549().field_7479 && !player.method_5765() && Utils.isLivingInJetSuit((class_1309)player) && this.getMode(stack) == ModeType.ELYTRA.getMode() && !player.method_6059(class_1294.field_5906)) {
                class_243 look;
                UniversalFluidItemStorage storage = this.getFluidTank(stack);
                if (storage.getFluidInTank(1).isEmpty()) {
                    return;
                }
                if (!(player.method_24828() || player.method_5799() || player.method_6059(class_1294.field_5902))) {
                    player.method_23669();
                    Utils.disableFlyAntiCheat(player, true);
                }
                if (player.method_6128() && player.method_5624()) {
                    look = player.method_5720();
                    class_243 motion = player.method_18798();
                    double boost = 0.1;
                    player.method_18799(motion.method_1031(look.field_1352 * boost, look.field_1351 * boost, look.field_1350 * boost));
                    if (this.nextFuelCheckTick <= 0) {
                        storage.drain(storage.getFluidInTank(1), false);
                        this.nextFuelCheckTick = 20;
                    }
                    --this.nextFuelCheckTick;
                }
                if (!player.method_37908().field_9236) {
                    look = player.method_5720();
                    class_3218 serverLevel = (class_3218)player.method_37908();
                    class_243 particlePos = player.method_19538().method_1020(look.method_1021(0.75)).method_1031(0.0, 0.25, 0.0);
                    serverLevel.method_14199((class_2394)class_2398.field_11240, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.15, 0.15, 0.15, 0.05);
                }
            }
        }

        public void switchJetSuitMode(class_1799 itemStack) {
            JetSuitComponent jetSuitComponent = this.getMode(itemStack) < 3 ? new JetSuitComponent(ModeType.fromInt(this.getMode(itemStack) + 1)) : new JetSuitComponent(ModeType.fromInt(0));
            itemStack.method_57379((class_9331)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)jetSuitComponent);
        }

        public void calculateSpacePressTime(class_1657 player, class_1799 itemStack) {
            int mode = this.getMode(itemStack);
            if (mode == ModeType.NORMAL.getMode()) {
                if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 2.2f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime > 0.0f) {
                    this.spacePressTime -= 0.2f;
                }
            }
            if (mode == ModeType.HOVER.getMode()) {
                if (!player.method_24828() && this.spacePressTime < 0.6f) {
                    this.spacePressTime += 0.2f;
                } else if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 1.4f) {
                        this.spacePressTime += 0.2f;
                        this.hoverModeMovement(player, itemStack);
                    }
                } else if (this.spacePressTime >= 0.6f) {
                    this.spacePressTime -= 0.2f;
                }
            }
            if (mode == ModeType.ELYTRA.getMode() && KeyVariables.isHoldingUp(player) && player.method_6128()) {
                if (player.method_5624()) {
                    if (this.spacePressTime < 2.8f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime < 2.2f) {
                    this.spacePressTime += 0.2f;
                }
            }
        }

        public void boost(class_1657 player, double boost, boolean sonicBoom) {
            class_243 vec31 = player.method_5720();
            if ((Utils.isLivingInJetSuit((class_1309)player) || Utils.isLivingInSpaceSuit((class_1309)player)) && player.method_6128()) {
                class_243 vec32 = player.method_18798();
                player.method_18799(vec32.method_1031(vec31.field_1352 * 0.1 + (vec31.field_1352 * boost - vec32.field_1352) * 0.5, vec31.field_1351 * 0.1 + (vec31.field_1351 * boost - vec32.field_1351) * 0.5, vec31.field_1350 * 0.1 + (vec31.field_1350 * boost - vec32.field_1350) * 0.5));
                if (sonicBoom) {
                    class_243 vec33 = player.method_5720().method_1021(6.5);
                    if (player.method_37908() instanceof class_3218) {
                        for (class_3222 p : ((class_3218)player.method_37908()).method_8503().method_3760().method_14571()) {
                            ((class_3218)player.method_37908()).method_14166(p, (class_2394)class_2398.field_11240, true, player.method_23317() - vec33.field_1352, player.method_23318() - vec33.field_1351, player.method_23321() - vec33.field_1350, 1, 0.0, 0.0, 0.0, 0.001);
                        }
                    }
                }
            }
        }

        @Override
        public boolean canElytraFly(class_1799 stack, class_1309 entity) {
            return Utils.isLivingInJetSuit(entity) && this.getMode(stack) == ModeType.ELYTRA.getMode();
        }

        @Override
        public boolean elytraFlightTick(class_1799 stack, class_1309 entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.method_37908().field_9236 && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                entity.method_32876((class_6880)class_5712.field_28158);
            }
            return true;
        }

        @Override
        public boolean tryToStartFallFlying(class_1657 player) {
            class_1799 itemStack;
            if (!player.method_24828() && !player.method_6128() && !player.method_5799() && !player.method_6059(class_1294.field_5902) && (itemStack = player.method_6118(class_1304.field_6174)).method_41406(ItemsRegistry.JETSUIT_SUIT) && class_1770.method_7804((class_1799)itemStack)) {
                player.method_23669();
                return true;
            }
            return false;
        }
    }
}

