/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.menus.GalaxyMenu;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.menus.TabletMenu;
import com.st0x0ef.stellaris.common.menus.WaitMenu;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class PlanetUtil {
    public static final class_2960 TEXTURE = ResourceLocationUtils.texture("planet_bar/earth_planet_bar");
    public static final class_2561 temperature = class_2561.method_43471((String)"text.stellaris.planetscreen.temperature");
    public static final class_2561 gravity = class_2561.method_43471((String)"text.stellaris.planetscreen.gravity");
    public static final class_2561 launch = class_2561.method_43471((String)"text.stellaris.planetscreen.launch");
    public static final class_2561 oxygen = class_2561.method_43471((String)"text.stellaris.planetscreen.oxygen");
    public static final class_2561 system = class_2561.method_43471((String)"text.stellaris.planetscreen.system");
    public static final class_2561 error_message = class_2561.method_43471((String)"text.stellaris.planetscreen.error_message");

    public static Planet getPlanet(class_2960 level) {
        AtomicReference p = new AtomicReference();
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                p.set(planet);
            }
        });
        return (Planet)p.get();
    }

    public static Planet getPlanetFromOrbit(class_2960 orbit) {
        AtomicReference p = new AtomicReference();
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.orbit().isPresent() && planet.orbit().get().equals((Object)orbit)) {
                p.set(planet);
            }
        });
        return (Planet)p.get();
    }

    public static boolean isPlanet(class_2960 level) {
        AtomicBoolean isPlanet = new AtomicBoolean(false);
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                isPlanet.set(true);
            }
        });
        return isPlanet.get();
    }

    public static boolean isOrbit(class_2960 level) {
        AtomicBoolean isOrbit = new AtomicBoolean(false);
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.orbit().isPresent() && planet.orbit().get().equals((Object)level)) {
                isOrbit.set(true);
            }
        });
        return isOrbit.get();
    }

    public static void ifPlanet(class_2960 level, Consumer<Planet> planetRunnable) {
        if (PlanetUtil.isPlanet(level)) {
            planetRunnable.accept(PlanetUtil.getPlanet(level));
        }
    }

    public static boolean hasOxygen(class_1937 level) {
        return !PlanetUtil.isPlanet(level.method_27983().method_29177()) || PlanetUtil.getPlanet(level.method_27983().method_29177()).oxygen();
    }

    public static boolean hasOxygenAt(class_3218 level, @NotNull class_2338 pos) {
        if (!PlanetUtil.hasOxygen((class_1937)level)) {
            return GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).hasOxygenAt(pos);
        }
        return true;
    }

    public static class_2960 getSpaceStationDimension(Planet planet) {
        return planet.orbit().isPresent() ? planet.orbit().get() : planet.dimension();
    }

    public static class_2960 getPlanetBar(class_2960 level) {
        if (PlanetUtil.isPlanet(level)) {
            return PlanetUtil.getPlanet(level).textures().planet_bar();
        }
        return class_2960.method_60655((String)"stellaris", (String)"textures/planet_bar/earth_planet_bar.png");
    }

    public static int openPlanetSelectionMenu(class_1657 player, final boolean forceCanGoTo, final String galaxyId) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_52964(forceCanGoTo);
                buffer.method_10814(galaxyId);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Planets");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PlanetSelectionMenu(syncId, inv, forceCanGoTo, galaxyId);
            }

            public static PlanetSelectionMenu create(int syncId, class_1661 inventory, class_2540 data) {
                boolean forceCanGoTo2 = data.readBoolean();
                String galaxyId2 = data.method_19772();
                return new PlanetSelectionMenu(syncId, inventory, forceCanGoTo2, galaxyId2);
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openWaitMenu(class_1657 player, final String playerChoosing) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_10814(playerChoosing);
            }

            @NotNull
            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Waiting");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                return WaitMenu.create(syncId, inv, buffer.method_10814(playerChoosing));
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openTabletMenu(class_1657 player, final class_2960 entry) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_10812(entry);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Tablet");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.method_10812(entry);
                return TabletMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openMilkyWayMenu(class_1657 player) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buf) {
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"MilkyWay");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                return GalaxyMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static class_5250[] getPlanetInfo(Planet planet) {
        class_5250 temperatureV = class_2561.method_43470((String)(temperature.getString() + " : " + (int)planet.temperature() + "\u00b0C"));
        class_5250 oxygenV = class_2561.method_43470((String)oxygen.getString());
        String gravityValue = String.valueOf(planet.gravity());
        if (gravityValue.length() > 4) {
            gravityValue = gravityValue.substring(0, 4);
        }
        class_5250 gravityV = class_2561.method_43470((String)(gravity.getString() + " : " + gravityValue + "m/s"));
        class_5250 systemV = class_2561.method_43470((String)(system.getString() + " : " + class_2561.method_43471((String)planet.system()).getString()));
        if (planet.oxygen()) {
            oxygenV.method_54663(Utils.getColorHexCode("Lime"));
        } else {
            oxygenV.method_54663(Utils.getColorHexCode("Red"));
        }
        if (planet.temperature() >= 100.0f) {
            temperatureV.method_54663(Utils.getColorHexCode("DarkRed"));
        } else if (planet.temperature() >= 0.0f) {
            temperatureV.method_54663(Utils.getColorHexCode("Lime"));
        } else if (planet.temperature() >= -100.0f) {
            temperatureV.method_54663(Utils.getColorHexCode("Cyan"));
        } else {
            temperatureV.method_54663(Utils.getColorHexCode("Blue"));
        }
        return new class_5250[]{temperatureV, oxygenV, gravityV, systemV};
    }

    public static class_5250 getInLinePlanetInfo(Planet planet) {
        class_5250[] component = PlanetUtil.getPlanetInfo(planet);
        return class_2561.method_43470((String)"").method_10852((class_2561)component[0]).method_27693(" | ").method_10852((class_2561)component[1]).method_27693(" | ").method_10852((class_2561)component[2]);
    }
}

