/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;

public class CreeperArmorLayer<T extends Creeper>
extends RenderLayer<T, CreeperModel<T>> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final HumanoidModel innerModel;
    private final HumanoidModel outerModel;
    private final TextureAtlas armorTrimAtlas;

    public CreeperArmorLayer(RenderLayerParent<T, CreeperModel<T>> pRenderer, EntityModelSet modelSets, ModelManager manager) {
        super(pRenderer);
        this.innerModel = new HumanoidModel(modelSets.m_171103_(ModelLayers.f_171208_));
        this.outerModel = new HumanoidModel(modelSets.m_171103_(ModelLayers.f_171261_));
        this.armorTrimAtlas = manager.m_119428_(Sheets.f_265912_);
    }

    public void copyPropertiesTo(HumanoidModel pModel) {
        pModel.f_102808_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("head"));
        pModel.f_102810_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("body"));
        pModel.f_102811_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("right_front_leg"));
        pModel.f_102812_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("left_front_leg"));
        pModel.f_102813_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("right_hind_leg"));
        pModel.f_102814_.m_104315_(((CreeperModel)this.m_117386_()).m_142109_().m_171324_("left_hind_leg"));
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack pPoseStack, MultiBufferSource pBuffer, T pLivingEntity, EquipmentSlot pSlot, int pPackedLight, HumanoidModel pModel) {
        ArmorItem armoritem;
        ItemStack itemstack = pLivingEntity.m_6844_(pSlot);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorItem && (armoritem = (ArmorItem)item).m_40402_() == pSlot) {
            ((CreeperModel)this.m_117386_()).m_102624_((EntityModel)pModel);
            this.copyPropertiesTo(pModel);
            this.setPartVisibility(pLivingEntity, pModel, pSlot);
            Model model = this.getArmorModelHook(pLivingEntity, itemstack, pSlot, pModel);
            boolean flag = this.usesInnerModel(pSlot);
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(pPoseStack, pBuffer, pPackedLight, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
                this.renderModel(pPoseStack, pBuffer, pPackedLight, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, "overlay"));
            } else {
                this.renderModel(pPoseStack, pBuffer, pPackedLight, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)pLivingEntity, itemstack, pSlot, null));
            }
            ArmorTrim.m_266285_((RegistryAccess)pLivingEntity.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(p_289638_ -> this.renderTrim(armoritem.m_40401_(), pPoseStack, pBuffer, pPackedLight, (ArmorTrim)p_289638_, model, flag));
            if (itemstack.m_41790_()) {
                this.renderGlint(pPoseStack, pBuffer, pPackedLight, model);
            }
        }
    }

    protected void setPartVisibility(T illager, HumanoidModel pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                pModel.f_102811_.f_104201_ += 2.0f;
                pModel.f_102812_.f_104201_ += 2.0f;
                break;
            }
            case LEGS: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102813_.f_104207_ = false;
                pModel.f_102814_.f_104207_ = false;
                break;
            }
            case FEET: {
                pModel.f_102813_.f_104207_ = false;
                pModel.f_102814_.f_104207_ = false;
            }
        }
    }

    private void renderModel(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, ArmorItem p_289650_, Model p_289658_, boolean p_289668_, float p_289678_, float p_289674_, float p_289693_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = p_289689_.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        p_289658_.m_7695_(p_289664_, vertexconsumer, p_289681_, OverlayTexture.f_118083_, p_289678_, p_289674_, p_289693_, 1.0f);
    }

    private void renderTrim(ArmorMaterial p_289690_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, IllagerModel p_289663_, boolean p_289651_) {
        this.renderTrim(p_289690_, p_289687_, p_289643_, p_289683_, p_289692_, p_289663_, p_289651_);
    }

    private void renderTrim(ArmorMaterial p_289690_, PoseStack p_289687_, MultiBufferSource p_289643_, int p_289683_, ArmorTrim p_289692_, Model p_289663_, boolean p_289651_) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(p_289651_ ? p_289692_.m_267774_(p_289690_) : p_289692_.m_267606_(p_289690_));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(p_289643_.m_6299_(Sheets.m_266442_()));
        p_289663_.m_7695_(p_289687_, vertexconsumer, p_289683_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, Model p_289659_) {
        p_289659_.m_7695_(p_289673_, p_289654_.m_6299_(RenderType.m_110484_()), p_289649_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private HumanoidModel getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation getArmorLocation(ArmorItem p_117081_, boolean p_117082_, @Nullable String p_117083_) {
        String s = "textures/models/armor/" + p_117081_.m_40401_().m_6082_() + "_layer_" + (p_117082_ ? 2 : 1) + (String)(p_117083_ == null ? "" : "_" + p_117083_) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        return ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

