/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HoglinArmorModel<T extends Mob>
extends AgeableListModel<T> {
    private static final float DEFAULT_HEAD_X_ROT = 0.87266463f;
    private static final float ATTACK_HEAD_X_ROT_END = -0.34906584f;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart body;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart mane;

    public HoglinArmorModel(ModelPart root) {
        super(true, 8.0f, 6.0f, 1.9f, 2.0f, 24.0f);
        this.body = root.m_171324_("body");
        this.mane = this.body.m_171324_("mane");
        this.head = root.m_171324_("head");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-8.0f, -7.0f, -13.0f, 16.0f, 14.0f, 26.0f, deformation), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        body.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(90, 33).m_171488_(0.0f, 0.0f, -9.0f, 0.0f, 10.0f, 19.0f, deformation.m_171469_(0.001f)), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)-5.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(61, 1).m_171488_(-7.0f, -3.0f, -19.0f, 14.0f, 6.0f, 19.0f, deformation), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-12.0f, (float)0.87266463f, (float)0.0f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-6.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f, deformation), PartPose.m_171423_((float)-6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.6981317f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(1, 6).m_171488_(0.0f, -1.0f, -2.0f, 6.0f, 1.0f, 4.0f, deformation), PartPose.m_171423_((float)6.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.6981317f));
        head.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(10, 13).m_171481_(-1.0f, -11.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.m_171419_((float)-7.0f, (float)2.0f, (float)-12.0f));
        head.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(1, 13).m_171481_(-1.0f, -11.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.m_171419_((float)7.0f, (float)2.0f, (float)-12.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(66, 42).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 14.0f, 6.0f, deformation), PartPose.m_171419_((float)-4.0f, (float)10.0f, (float)-8.5f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(41, 42).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 14.0f, 6.0f, deformation), PartPose.m_171419_((float)4.0f, (float)10.0f, (float)-8.5f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(21, 45).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)13.0f, (float)10.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 45).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f, deformation), PartPose.m_171419_((float)5.0f, (float)13.0f, (float)10.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindLeg, (Object)this.leftHindLeg);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightEar.f_104205_ = -0.6981317f - limbSwingAmount * Mth.m_14031_((float)limbSwing);
        this.leftEar.f_104205_ = 0.6981317f + limbSwingAmount * Mth.m_14031_((float)limbSwing);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        int attackTicks = ((HoglinBase)entity).m_7575_();
        float f = 1.0f - (float)Math.abs(10 - 2 * attackTicks) / 10.0f;
        this.head.f_104203_ = Mth.m_14179_((float)f, (float)0.87266463f, (float)-0.34906584f);
        if (entity.m_6162_()) {
            this.head.f_104201_ = Mth.m_14179_((float)f, (float)2.0f, (float)5.0f);
            this.mane.f_104202_ = -3.0f;
        } else {
            this.head.f_104201_ = 2.0f;
            this.mane.f_104202_ = -7.0f;
        }
        float swing = 1.2f;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)limbSwing) * swing * limbSwingAmount;
        this.rightHindLeg.f_104203_ = this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * swing * limbSwingAmount;
        this.leftHindLeg.f_104203_ = this.rightFrontLeg.f_104203_;
    }
}

