/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.animarmor.ArmoredVindicator;
import net.mcreator.animarmor.ClientEvents;
import net.mcreator.animarmor.IllagerArmorModel;
import net.mcreator.animarmor.IllagerHumanoidModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public abstract class IllagerArmorRenderer<T extends AbstractIllager>
extends MobRenderer<T, IllagerHumanoidModel<T>> {
    public IllagerArmorRenderer(EntityRendererProvider.Context context) {
        super(context, new IllagerHumanoidModel(context.m_174023_(ClientEvents.ILLAGER)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new IllagerArmorModel(context.m_174023_(ClientEvents.ILLAGER_INNER_LAYER_ARMOR)), new IllagerArmorModel(context.m_174023_(ClientEvents.ILLAGER_OUTER_LAYER_ARMOR)), context.m_266367_()));
    }

    protected void scale(T entity, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void setModelVisibilities(T entityIn) {
        ArmoredVindicator av;
        IllagerHumanoidModel model = (IllagerHumanoidModel)this.m_7200_();
        ItemStack main = entityIn.m_21205_();
        ItemStack off = entityIn.m_21206_();
        boolean isRoyalGuard = entityIn instanceof ArmoredVindicator && (av = (ArmoredVindicator)entityIn).isRoyalGuard();
        boolean attacking = entityIn.m_6768_() == AbstractIllager.IllagerArmPose.ATTACKING;
        boolean crossed = entityIn.m_6768_() == AbstractIllager.IllagerArmPose.CROSSED;
        HumanoidModel.ArmPose poseOff = this.getArmPose(entityIn, main, off, InteractionHand.OFF_HAND);
        HumanoidModel.ArmPose poseMain = isRoyalGuard ? (!(attacking || crossed || main.m_41619_()) ? HumanoidModel.ArmPose.ITEM : this.getArmPose(entityIn, main, off, InteractionHand.MAIN_HAND)) : this.getArmPose(entityIn, main, off, InteractionHand.MAIN_HAND);
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            model.f_102816_ = poseMain;
            model.f_102815_ = poseOff;
        } else {
            model.f_102816_ = poseOff;
            model.f_102815_ = poseMain;
        }
    }

    protected HumanoidModel.ArmPose getArmPose(T entityIn, ItemStack itemStackMain, ItemStack itemStackOff, InteractionHand handIn) {
        ItemStack itemstack;
        HumanoidModel.ArmPose bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemStack = itemstack = handIn == InteractionHand.MAIN_HAND ? itemStackMain : itemStackOff;
        if (!itemstack.m_41619_()) {
            bipedmodel$armpose = HumanoidModel.ArmPose.ITEM;
            UseAnim useaction = itemstack.m_41780_();
            switch (useaction) {
                case BLOCK: {
                    if (entityIn.m_6117_() && entityIn.m_7655_() == handIn) {
                        bipedmodel$armpose = HumanoidModel.ArmPose.BLOCK;
                        break;
                    }
                    bipedmodel$armpose = HumanoidModel.ArmPose.ITEM;
                    break;
                }
                case BOW: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    bipedmodel$armpose = HumanoidModel.ArmPose.THROW_SPEAR;
                    break;
                }
                case CROSSBOW: {
                    if (handIn != entityIn.m_7655_() || entityIn.m_21212_() <= 0) break;
                    bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case SPYGLASS: {
                    if (entityIn.m_21212_() <= 0) break;
                    bipedmodel$armpose = HumanoidModel.ArmPose.SPYGLASS;
                    break;
                }
                default: {
                    if (entityIn instanceof ArmoredVindicator) {
                        ArmoredVindicator av = (ArmoredVindicator)entityIn;
                        break;
                    }
                    bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
                }
            }
        }
        if (!((AbstractIllager)entityIn).f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && !entityIn.m_6117_()) {
            bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return bipedmodel$armpose;
    }
}

