/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import java.util.EnumSet;
import net.mcreator.animarmor.OwnableRabbit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class RabbitFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final Rabbit rabbit;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public RabbitFollowOwnerGoal(Rabbit rabbit, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.rabbit = rabbit;
        this.level = rabbit.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = rabbit.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Rabbit rabbit = this.rabbit;
        if (!(rabbit instanceof OwnableRabbit)) {
            return false;
        }
        OwnableRabbit ownable = (OwnableRabbit)rabbit;
        LivingEntity owner = ownable.m_269323_();
        if (owner == null) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (ownable.isOrderedToSit()) {
            return false;
        }
        if (this.rabbit.m_20280_((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        Rabbit rabbit = this.rabbit;
        if (!(rabbit instanceof OwnableRabbit)) {
            return false;
        }
        OwnableRabbit ownable = (OwnableRabbit)rabbit;
        if (ownable.isOrderedToSit()) {
            return false;
        }
        return !(this.rabbit.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.rabbit.m_21439_(BlockPathTypes.WATER);
        this.rabbit.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.rabbit.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.rabbit.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.rabbit.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.rabbit.m_20280_((Entity)this.owner) >= 144.0) {
                this.teleportToOwner();
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int dx = this.randomIntInclusive(-3, 3);
            int dy = this.randomIntInclusive(-1, 1);
            int dz = this.randomIntInclusive(-3, 3);
            boolean success = this.maybeTeleportTo(blockpos.m_123341_() + dx, blockpos.m_123342_() + dy, blockpos.m_123343_() + dz);
            if (!success) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.rabbit.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.rabbit.m_146908_(), this.rabbit.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (type != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState below = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && below.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos offset = pos.m_121996_((Vec3i)this.rabbit.m_20183_());
        return this.level.m_45756_((Entity)this.rabbit, this.rabbit.m_20191_().m_82338_(offset));
    }

    private int randomIntInclusive(int min, int max) {
        return this.rabbit.m_217043_().m_188503_(max - min + 1) + min;
    }
}

