/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.animarmor.BannerAttachment;
import net.mcreator.animarmor.ClientEvents;
import net.mcreator.animarmor.HogArmorItem;
import net.mcreator.animarmor.HoglinArmorModel;
import net.mcreator.animarmor.OwnableHoglin;
import net.mcreator.animarmor.client.model.Modellava_launcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HoglinModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HoglinRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TamedHoglinRenderer
extends HoglinRenderer {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("textures/entity/hoglin/hoglin.png");
    private static final ResourceLocation RED_TEXTURE = new ResourceLocation("animarmor:textures/entities/hoglin_red.png");
    private static final ResourceLocation PURPLE_TEXTURE = new ResourceLocation("animarmor:textures/entities/hoglin_purple.png");
    private static final ResourceLocation REDDER_TEXTURE = new ResourceLocation("animarmor:textures/entities/hoglin_redder.png");
    private static final ResourceLocation SADDLE_TEXTURE = new ResourceLocation("animarmor:textures/entities/hoglin_saddle.png");

    public TamedHoglinRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.m_115326_(new GreaseLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this));
        this.m_115326_(new SaddleLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this, context.m_174027_()));
        this.m_115326_(new HogArmorLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this, context.m_174027_()));
        this.m_115326_(new SkullLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this, context.m_174027_()));
        this.m_115326_(new DyeLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this));
        this.m_115326_(new BannerLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this));
        this.m_115326_(new LavaLauncherLayer((RenderLayerParent<Hoglin, HoglinModel<Hoglin>>)this, context.m_174027_()));
    }

    public ResourceLocation m_5478_(Hoglin hoglin) {
        if (hoglin instanceof OwnableHoglin) {
            OwnableHoglin ownable = (OwnableHoglin)hoglin;
            switch (ownable.getVariant()) {
                case 2: {
                    return RED_TEXTURE;
                }
                case 3: {
                    return PURPLE_TEXTURE;
                }
                case 4: {
                    return REDDER_TEXTURE;
                }
            }
            return DEFAULT_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    protected void scale(Hoglin hoglin, PoseStack poseStack, float partialTicks) {
        OwnableHoglin ownable;
        float scale = 1.0f;
        if (hoglin instanceof OwnableHoglin && (ownable = (OwnableHoglin)hoglin).isTame()) {
            scale = ownable.getGrowthScale();
        }
        poseStack.m_85841_(scale, scale, scale);
        this.f_114477_ = 0.7f * scale;
    }

    public class GreaseLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private static final ResourceLocation GREASE_TEXTURE = new ResourceLocation("animarmor:textures/entities/creamed_hog.png");

        public GreaseLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            OwnableHoglin ownable;
            if (!(hoglin instanceof OwnableHoglin) || !(ownable = (OwnableHoglin)hoglin).isTame() || ownable.getGreaseLevel() <= 0 || hoglin.m_20145_()) {
                return;
            }
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)GREASE_TEXTURE));
            float grease = (float)ownable.getGreaseLevel() / 3.0f;
            int fullbright = 0xF000F0;
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            ((HoglinModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, fullbright, overlay, 1.0f, 1.0f, 1.0f, grease);
        }
    }

    public static class SaddleLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private final HoglinArmorModel<Hoglin> model;

        public SaddleLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent, EntityModelSet models) {
            super(parent);
            this.model = new HoglinArmorModel(models.m_171103_(ClientEvents.HOGLIN_SADDLE_LAYER));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack saddleStack = hoglin.m_6844_(EquipmentSlot.MAINHAND);
            if (saddleStack.m_41619_() || !saddleStack.m_150930_(Items.f_42450_) || hoglin.m_20145_()) {
                return;
            }
            ((HoglinModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)hoglin, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(hoglin, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)SADDLE_TEXTURE));
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class HogArmorLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private final HoglinArmorModel<Hoglin> model;

        public HogArmorLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent, EntityModelSet models) {
            super(parent);
            this.model = new HoglinArmorModel(models.m_171103_(ClientEvents.HOGLIN_ARMOR_LAYER));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            HogArmorItem hogArmor;
            ItemStack armorStack;
            block5: {
                block4: {
                    Item item;
                    armorStack = hoglin.m_6844_(EquipmentSlot.CHEST);
                    if (armorStack.m_41619_() || !((item = armorStack.m_41720_()) instanceof HogArmorItem)) break block4;
                    hogArmor = (HogArmorItem)item;
                    if (!hoglin.m_20145_()) break block5;
                }
                return;
            }
            ((HoglinModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)hoglin, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(hoglin, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ResourceLocation armorTex = hogArmor.getTexture();
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)armorTex));
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            Item item = armorStack.m_41720_();
            if (item instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
                int color = dyeable.m_41121_(armorStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                ResourceLocation overlayTex = new ResourceLocation("animarmor:textures/entities/leather_hoglin_armor_overlay.png");
                VertexConsumer overlayConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)overlayTex));
                this.model.m_7695_(poseStack, overlayConsumer, light, overlay, r, g, b, 1.0f);
            }
        }
    }

    public static class SkullLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private static final ResourceLocation SKULL_TEXTURE = new ResourceLocation("animarmor:textures/entities/hog_skull.png");
        private final HoglinArmorModel<Hoglin> model;

        public SkullLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent, EntityModelSet models) {
            super(parent);
            this.model = new HoglinArmorModel(models.m_171103_(ClientEvents.HOGLIN_SKULL_LAYER));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!(hoglin instanceof OwnableHoglin)) {
                return;
            }
            OwnableHoglin ownable = (OwnableHoglin)hoglin;
            ItemStack skullStack = ownable.getSkullItem();
            if (skullStack.m_41619_() || hoglin.m_20145_()) {
                return;
            }
            ((HoglinModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((Entity)hoglin, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim(hoglin, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)SKULL_TEXTURE));
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class DyeLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private static final ResourceLocation MARKINGS_TEXTURE = new ResourceLocation("animarmor:textures/entities/hoglin_markings.png");

        public DyeLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            OwnableHoglin ownable;
            if (!(hoglin instanceof OwnableHoglin) || !(ownable = (OwnableHoglin)hoglin).isTame() || hoglin.m_20145_()) {
                return;
            }
            int color = ownable.getDyeColor();
            if (color == 0xFFFFFF || color == 0) {
                return;
            }
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)MARKINGS_TEXTURE));
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            ((HoglinModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, light, overlay, r, g, b, 1.0f);
        }
    }

    public class BannerLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        public BannerLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!(hoglin instanceof BannerAttachment)) {
                return;
            }
            BannerAttachment attachment = (BannerAttachment)hoglin;
            ItemStack banner = attachment.getBannerItem();
            if (banner.m_41619_() || !(banner.m_41720_() instanceof BannerItem)) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.375, 0.0);
            Level level = hoglin.m_9236_();
            int light = level != null ? LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)hoglin.m_20183_()) : 0xF000F0;
            poseStack.m_85836_();
            poseStack.m_252880_(-0.5f, -0.25f, 1.2f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            BannerBlockEntity bannerEntity = new BannerBlockEntity(BlockPos.f_121853_, BannerBlock.m_49814_((Item)banner.m_41720_()).m_49966_());
            bannerEntity.m_142339_(level);
            bannerEntity.m_58489_(banner, bannerEntity.m_155044_());
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_((BlockEntity)bannerEntity);
            if (renderer != null) {
                renderer.m_6922_((BlockEntity)bannerEntity, partialTicks, poseStack, buffer, light, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public static class LavaLauncherLayer
    extends RenderLayer<Hoglin, HoglinModel<Hoglin>> {
        private static final ResourceLocation Modellava_launcher_TEX = new ResourceLocation("animarmor:textures/entities/lava_launcher.png");
        private final Modellava_launcher<Hoglin> model;

        public LavaLauncherLayer(RenderLayerParent<Hoglin, HoglinModel<Hoglin>> parent, EntityModelSet models) {
            super(parent);
            ModelPart baked = models.m_171103_(Modellava_launcher.LAYER_LOCATION);
            this.model = new Modellava_launcher(baked);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, Hoglin hoglin, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            OwnableHoglin ownable;
            if (hoglin.m_20145_()) {
                return;
            }
            if (!(hoglin instanceof OwnableHoglin) || !(ownable = (OwnableHoglin)hoglin).getLavaLauncher()) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -1.5f, 0.0f);
            ((HoglinModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6973_(hoglin, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vc = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)Modellava_launcher_TEX));
            int overlay = LivingEntityRenderer.m_115338_((LivingEntity)hoglin, (float)0.0f);
            this.model.m_7695_(poseStack, vc, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }
}

