/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.UUID;
import net.mcreator.animarmor.BirdArmorItem;
import net.mcreator.animarmor.item.NetheriteBirdArmorItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Parrot.class})
public abstract class BirdArmorMixin
extends LivingEntity {
    @Unique
    protected SimpleContainer inventory;
    @Unique
    private static final int INV_SLOT_ARMOR = 0;
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("07b5e37c-3f7f-4e08-915f-5c88d5f9a77e");

    protected BirdArmorMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void animarmor$createParrotInventory(EntityType<? extends Parrot> type, Level level, CallbackInfo ci) {
        this.createInventory();
    }

    @Unique
    protected void createInventory() {
        SimpleContainer old = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (old != null) {
            old.m_19181_(this::containerChanged);
            ItemStack itemstack = old.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.inventory.m_6836_(0, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_(this::containerChanged);
        this.updateContainerEquipment();
    }

    @Unique
    protected void updateContainerEquipment() {
        Parrot self = (Parrot)this;
        if (!self.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(0));
        }
    }

    @Unique
    protected void containerChanged(Container container) {
        this.updateContainerEquipment();
    }

    @Unique
    protected void setArmorEquipment(ItemStack armor) {
        int protection;
        Parrot self = (Parrot)this;
        self.m_8061_(EquipmentSlot.CHEST, armor);
        self.m_21409_(EquipmentSlot.CHEST, 0.0f);
        AttributeInstance attr = self.m_21051_(Attributes.f_22284_);
        if (attr == null) {
            return;
        }
        attr.m_22120_(ARMOR_MODIFIER_UUID);
        if (this.isArmor(armor) && (protection = ((BirdArmorItem)armor.m_41720_()).getProtection()) > 0) {
            attr.m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Parrot armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Parrot self = (Parrot)this;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ItemStack current = this.inventory.m_8020_(0);
        if (player.m_6144_() && !current.m_41619_() && self.m_21824_()) {
            self.m_19983_(current);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
            self.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
            cir.setReturnValue((Object)InteractionResult.CONSUME);
            return;
        }
        if (item instanceof BirdArmorItem) {
            BirdArmorItem armorItem = (BirdArmorItem)item;
            if (self.m_21824_()) {
                if (!current.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)current)) {
                    cir.setReturnValue((Object)InteractionResult.PASS);
                    return;
                }
                ItemStack newArmor = stack.m_255036_(1);
                if (!current.m_41619_()) {
                    self.m_19983_(current);
                }
                this.inventory.m_6836_(0, newArmor);
                this.setArmorEquipment(newArmor);
                self.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void animarmor$saveArmor(CompoundTag nbt, CallbackInfo ci) {
        ItemStack armor = this.inventory.m_8020_(0);
        if (!armor.m_41619_()) {
            nbt.m_128365_("ArmorItem", (Tag)armor.m_41739_(new CompoundTag()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void animarmor$loadArmor(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("ArmorItem", 10)) {
            ItemStack armor = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ArmorItem"));
            this.inventory.m_6836_(0, armor);
            this.setArmorEquipment(armor);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
        if (!armor.m_41619_()) {
            this.m_19983_(armor.m_41777_());
            this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Parrot bird = (Parrot)this;
        ItemStack armor = bird.m_6844_(EquipmentSlot.CHEST);
        if (armor.m_41720_() instanceof NetheriteBirdArmorItem && (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_))) {
            bird.m_7311_(0);
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Unique
    public boolean canWearArmor() {
        return true;
    }

    @Unique
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof BirdArmorItem;
    }

    @Unique
    public boolean isWearingArmor() {
        return !this.inventory.m_8020_(0).m_41619_();
    }
}

