/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.Optional;
import java.util.UUID;
import net.mcreator.animarmor.KitArmorItem;
import net.mcreator.animarmor.item.NetheriteKitArmorItem;
import net.mcreator.animarmor.mixins.FoxAccessorMixin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Fox.class})
public abstract class FoxArmorMixin
extends Animal {
    @Unique
    private boolean animarmor$forcedSit = false;
    @Shadow
    @Final
    private static EntityDataAccessor<Optional<UUID>> f_28439_;
    @Shadow
    @Final
    private static EntityDataAccessor<Optional<UUID>> f_28440_;
    @Unique
    protected SimpleContainer inventory;
    @Unique
    private static final int INV_SLOT_ARMOR = 0;
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID;

    protected FoxArmorMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void animarmor$createFoxInventory(EntityType<? extends Fox> type, Level level, CallbackInfo ci) {
        this.createInventory();
    }

    @Unique
    protected void createInventory() {
        SimpleContainer old = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (old != null) {
            old.m_19181_(this::containerChanged);
            ItemStack itemstack = old.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.inventory.m_6836_(0, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_(this::containerChanged);
        this.updateContainerEquipment();
    }

    @Unique
    protected void updateContainerEquipment() {
        Fox self = (Fox)this;
        if (!self.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(0));
        }
    }

    @Unique
    protected void containerChanged(Container container) {
        this.updateContainerEquipment();
    }

    @Unique
    protected void setArmorEquipment(ItemStack armor) {
        int protection;
        Fox self = (Fox)this;
        self.m_8061_(EquipmentSlot.CHEST, armor);
        self.m_21409_(EquipmentSlot.CHEST, 0.0f);
        AttributeInstance attr = self.m_21051_(Attributes.f_22284_);
        if (attr == null) {
            return;
        }
        attr.m_22120_(ARMOR_MODIFIER_UUID);
        if (this.isArmor(armor) && (protection = ((KitArmorItem)armor.m_41720_()).getProtection()) > 0) {
            attr.m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Fox armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Fox self = (Fox)this;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ItemStack current = this.inventory.m_8020_(0);
        boolean trusted = ((FoxAccessorMixin)self).callTrusts(player.m_20148_());
        ItemStack mouth = self.m_6844_(EquipmentSlot.MAINHAND);
        if (trusted && stack.m_41619_() && !player.m_6144_()) {
            this.animarmor$forcedSit = !this.animarmor$forcedSit;
            self.m_28610_(this.animarmor$forcedSit);
            self.m_21573_().m_26573_();
            self.m_6710_(null);
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
            this.f_20901_ = 0.0f;
            return InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_);
        }
        if (trusted && player.m_6144_() && stack.m_41619_() && !mouth.m_41619_()) {
            self.m_19983_(mouth.m_41777_());
            self.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            self.m_5496_(SoundEvents.f_12019_, 0.4f, 1.4f);
            return InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_);
        }
        if (player.m_6144_() && !current.m_41619_() && trusted) {
            self.m_19983_(current);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
            self.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_);
        }
        if (item instanceof KitArmorItem) {
            KitArmorItem armorItem = (KitArmorItem)item;
            if (trusted) {
                if (!current.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)current)) {
                    return InteractionResult.PASS;
                }
                ItemStack newArmor = stack.m_255036_(1);
                if (!current.m_41619_()) {
                    self.m_19983_(current);
                }
                this.inventory.m_6836_(0, newArmor);
                this.setArmorEquipment(newArmor);
                self.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Inject(method={"setSitting"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$preventAISitOverride(boolean sitting, CallbackInfo ci) {
        if (this.animarmor$forcedSit && !sitting) {
            ci.cancel();
        }
    }

    @Inject(method={"canMove"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$forceNoMove(CallbackInfoReturnable<Boolean> cir) {
        if (this.animarmor$forcedSit) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void animarmor$freezeMovement(CallbackInfo ci) {
        if (this.animarmor$forcedSit) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
            this.f_20901_ = 0.0f;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.animarmor$forcedSit) {
            Fox self = (Fox)this;
            self.m_21573_().m_26573_();
            self.m_6710_(null);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void animarmor$saveArmor(CompoundTag nbt, CallbackInfo ci) {
        ItemStack armor = this.inventory.m_8020_(0);
        if (!armor.m_41619_()) {
            nbt.m_128365_("ArmorItem", (Tag)armor.m_41739_(new CompoundTag()));
        }
        nbt.m_128379_("ForcedSit", this.animarmor$forcedSit);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void animarmor$loadArmor(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("ArmorItem", 10)) {
            ItemStack armor = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ArmorItem"));
            this.inventory.m_6836_(0, armor);
            this.setArmorEquipment(armor);
        }
        if (nbt.m_128441_("ForcedSit")) {
            this.animarmor$forcedSit = nbt.m_128471_("ForcedSit");
            ((Fox)this).m_28610_(this.animarmor$forcedSit);
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
        if (!armor.m_41619_()) {
            this.m_19983_(armor.m_41777_());
            this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Fox fox = (Fox)this;
        ItemStack armor = fox.m_6844_(EquipmentSlot.CHEST);
        if (armor.m_41720_() instanceof NetheriteKitArmorItem && (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_))) {
            fox.m_7311_(0);
            return false;
        }
        if (this.animarmor$forcedSit) {
            this.animarmor$forcedSit = false;
            fox.m_28610_(false);
        }
        return super.m_6469_(source, amount);
    }

    @Unique
    private boolean animarmor$isTrusted() {
        Fox self = (Fox)this;
        Optional id0 = (Optional)self.m_20088_().m_135370_(f_28439_);
        Optional id1 = (Optional)self.m_20088_().m_135370_(f_28440_);
        return id0.isPresent() || id1.isPresent();
    }

    public boolean m_6779_(LivingEntity target) {
        if (this.animarmor$isTrusted() && target.m_6095_() == EntityType.f_20517_) {
            return false;
        }
        return super.m_6779_(target);
    }

    @Unique
    public boolean canWearArmor() {
        return true;
    }

    @Unique
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof KitArmorItem;
    }

    @Unique
    public boolean isWearingArmor() {
        return !this.inventory.m_8020_(0).m_41619_();
    }

    static {
        ARMOR_MODIFIER_UUID = UUID.fromString("07b5e37c-3f7f-4e08-915f-5c88d5f9a77e");
    }
}

