/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.UUID;
import net.mcreator.animarmor.OwnableHoglin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Hoglin.class})
public abstract class HoglinGreaseMixin
extends Animal
implements OwnableHoglin {
    @Unique
    private static final EntityDataAccessor<Integer> DATA_GREASE_ID = SynchedEntityData.m_135353_(HoglinGreaseMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final UUID GREASE_DAMAGE_MODIFIER_UUID = UUID.fromString("012de50e-fb4b-4d92-b34f-457a339c3361");
    @Unique
    private static final UUID GREASE_SPEED_MODIFIER_UUID = UUID.fromString("c2d2e3e1-b234-4c9b-9a22-334d1aab4d55");
    @Unique
    private static final String GREASE_DAMAGE_NAME = "Grease damage bonus";
    @Unique
    private static final String GREASE_SPEED_NAME = "Grease speed bonus";

    protected HoglinGreaseMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void animarmor$defineTamableData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_GREASE_ID, (Object)0);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$saveTameData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("Grease", this.getGreaseLevel());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$loadTameData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("Grease")) {
            this.setGreaseLevel(tag.m_128451_("Grease"));
        }
    }

    @Override
    @Unique
    public int getGreaseLevel() {
        return (Integer)this.f_19804_.m_135370_(DATA_GREASE_ID);
    }

    @Override
    @Unique
    public void setGreaseLevel(int value) {
        int clamped = Math.min(3, Math.max(0, value));
        this.f_19804_.m_135381_(DATA_GREASE_ID, (Object)clamped);
        this.animarmor$updateGreaseDamageModifier();
        this.animarmor$updateGreaseSpeedModifier();
    }

    @Unique
    private void animarmor$updateGreaseDamageModifier() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (attack == null) {
            return;
        }
        attack.m_22120_(GREASE_DAMAGE_MODIFIER_UUID);
        int grease = this.getGreaseLevel();
        if (grease > 0) {
            double bonusDamage = (double)grease * 2.0;
            AttributeModifier modifier = new AttributeModifier(GREASE_DAMAGE_MODIFIER_UUID, GREASE_DAMAGE_NAME, bonusDamage, AttributeModifier.Operation.ADDITION);
            attack.m_22125_(modifier);
        }
    }

    @Unique
    private void animarmor$updateGreaseSpeedModifier() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
        if (speed == null) {
            return;
        }
        speed.m_22120_(GREASE_SPEED_MODIFIER_UUID);
        int grease = this.getGreaseLevel();
        if (grease > 0) {
            double bonusSpeed = (double)grease * 0.2;
            AttributeModifier modifier = new AttributeModifier(GREASE_SPEED_MODIFIER_UUID, GREASE_SPEED_NAME, bonusSpeed, AttributeModifier.Operation.MULTIPLY_TOTAL);
            speed.m_22125_(modifier);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void forge$tameAndGrease(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack held = player.m_21120_(hand);
        if (this.isTame() && held.m_150930_(Items.f_42542_)) {
            int grease = this.getGreaseLevel();
            if (grease < 3) {
                this.setGreaseLevel(grease + 1);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_146852_(GameEvent.f_157806_, (Entity)player);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                }
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_144178_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

