/*
 * Decompiled with CFR 0.152.
 */
package com.lostmortal.advancedcamera;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class AdvancedCameraConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "advancedcamera.json");
    public double CAM_Z_DEFAULT = 4.0;
    public double CAM_X_DEFAULT = 0.0;
    public double CAM_Y_DEFAULT = 0.0;
    public double CAM_Z_MEDIUM = 8.0;
    public double CAM_X_MEDIUM = 0.0;
    public double CAM_Y_MEDIUM = 3.0;
    public double CAM_Z_LONG = 12.0;
    public double CAM_X_LONG = 0.0;
    public double CAM_Y_LONG = 6.0;
    public double CAM_Z_DEFAULT_HORSE = 1.0;
    public double CAM_Z_BOW = 1.5;
    public double CAM_X_BOW = 1.0;
    public double CAM_Y_BOW = 0.0;
    public double CAM_SMOOTHING = 0.2;

    public static AdvancedCameraConfig load() {
        try {
            if (CONFIG_FILE.exists()) {
                FileReader reader = new FileReader(CONFIG_FILE);
                AdvancedCameraConfig cfg = (AdvancedCameraConfig)GSON.fromJson((Reader)reader, AdvancedCameraConfig.class);
                reader.close();
                return cfg;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new AdvancedCameraConfig();
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)this, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

