/*
 * Decompiled with CFR 0.152.
 */
package com.lostmortal.advancedcamera;

import com.lostmortal.advancedcamera.AdvancedCameraClient;
import com.lostmortal.advancedcamera.AdvancedCameraConfig;
import com.lostmortal.advancedcamera.CameraPositionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class AdvancedCameraConfigScreen
extends class_437 {
    private final class_437 parent;
    private final CameraPositionManager manager;
    private double scrollY = 0.0;
    private double maxScroll = 0.0;
    private int contentHeight = 0;
    private final List<Row> rows = new ArrayList<Row>();
    private static final int ROW_HEIGHT = 22;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 80;

    public AdvancedCameraConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Advanced Camera Config"));
        this.parent = parent;
        this.manager = AdvancedCameraClient.CAMERA_POSITION_MANAGER;
    }

    protected void method_25426() {
        this.rows.clear();
        this.contentHeight = 0;
        int centerX = this.field_22789 / 2;
        int y = 30;
        int labelWidth = 180;
        int buttonWidth = 20;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Z Default", () -> this.manager.CAM_Z_DEFAULT, v -> {
            this.manager.CAM_Z_DEFAULT = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "X Default", () -> this.manager.CAM_X_DEFAULT, v -> {
            this.manager.CAM_X_DEFAULT = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Y Default", () -> this.manager.CAM_Y_DEFAULT, v -> {
            this.manager.CAM_Y_DEFAULT = v;
        }, 0.25);
        y += 22;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Z Medium", () -> this.manager.CAM_Z_MEDIUM, v -> {
            this.manager.CAM_Z_MEDIUM = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "X Medium", () -> this.manager.CAM_X_MEDIUM, v -> {
            this.manager.CAM_X_MEDIUM = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Y Medium", () -> this.manager.CAM_Y_MEDIUM, v -> {
            this.manager.CAM_Y_MEDIUM = v;
        }, 0.25);
        y += 22;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Z Long", () -> this.manager.CAM_Z_LONG, v -> {
            this.manager.CAM_Z_LONG = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "X Long", () -> this.manager.CAM_X_LONG, v -> {
            this.manager.CAM_X_LONG = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Y Long", () -> this.manager.CAM_Y_LONG, v -> {
            this.manager.CAM_Y_LONG = v;
        }, 0.25);
        y += 22;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Z Default Horse", () -> this.manager.CAM_Z_DEFAULT_HORSE, v -> {
            this.manager.CAM_Z_DEFAULT_HORSE = v;
        }, 0.25);
        y += 22;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Z Bow", () -> this.manager.CAM_Z_BOW, v -> {
            this.manager.CAM_Z_BOW = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "X Bow", () -> this.manager.CAM_X_BOW, v -> {
            this.manager.CAM_X_BOW = v;
        }, 0.25);
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Y Bow", () -> this.manager.CAM_Y_BOW, v -> {
            this.manager.CAM_Y_BOW = v;
        }, 0.25);
        y += 22;
        y = this.addRow(centerX, y, labelWidth, buttonWidth, "Smoothing", () -> this.manager.CAM_SMOOTHING, v -> {
            this.manager.CAM_SMOOTHING = v;
            this.clampSmoothing();
        }, 0.05);
        this.contentHeight = y - 20;
        this.updateMaxScroll();
        int bottomY = this.field_22790 - 25 - 44;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset to Defaults"), b -> this.resetToDefaults()).method_46434(centerX - 100, bottomY, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> this.method_25419()).method_46434(centerX - 100, bottomY + 22 + 4, 200, 20).method_46431());
    }

    private int addRow(int centerX, int baseY, int labelWidth, int buttonWidth, String label, DoubleSupplier getter, DoubleConsumer setter, double step) {
        int y = baseY;
        class_4185 labelButton = class_4185.method_46430((class_2561)this.makeLabel(label, getter.getAsDouble()), b -> {}).method_46434(centerX - labelWidth / 2, y, labelWidth, 20).method_46431();
        this.method_37063((class_364)labelButton);
        class_4185 minusButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), b -> {
            setter.accept(getter.getAsDouble() - step);
            if ("Smoothing".equals(label)) {
                this.clampSmoothing();
            }
            labelButton.method_25355(this.makeLabel(label, getter.getAsDouble()));
        }).method_46434(centerX - labelWidth / 2 - buttonWidth - 4, y, buttonWidth, 20).method_46431();
        this.method_37063((class_364)minusButton);
        class_4185 plusButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), b -> {
            setter.accept(getter.getAsDouble() + step);
            if ("Smoothing".equals(label)) {
                this.clampSmoothing();
            }
            labelButton.method_25355(this.makeLabel(label, getter.getAsDouble()));
        }).method_46434(centerX + labelWidth / 2 + 4, y, buttonWidth, 20).method_46431();
        this.method_37063((class_364)plusButton);
        this.rows.add(new Row(baseY, minusButton, labelButton, plusButton));
        return baseY + 22;
    }

    private class_2561 makeLabel(String name, double value) {
        return class_2561.method_43470((String)(name + ": " + String.format(Locale.ROOT, "%.2f", value)));
    }

    private void clampSmoothing() {
        if (this.manager.CAM_SMOOTHING < 0.01) {
            this.manager.CAM_SMOOTHING = 0.01;
        }
        if (this.manager.CAM_SMOOTHING > 1.0) {
            this.manager.CAM_SMOOTHING = 1.0;
        }
    }

    private void resetToDefaults() {
        this.manager.CAM_Z_DEFAULT = 4.0;
        this.manager.CAM_X_DEFAULT = 0.0;
        this.manager.CAM_Y_DEFAULT = 0.0;
        this.manager.CAM_Z_DEFAULT_HORSE = 1.0;
        this.manager.CAM_Z_MEDIUM = 8.0;
        this.manager.CAM_X_MEDIUM = 0.0;
        this.manager.CAM_Y_MEDIUM = 3.0;
        this.manager.CAM_Z_LONG = 12.0;
        this.manager.CAM_X_LONG = 0.0;
        this.manager.CAM_Y_LONG = 6.0;
        this.manager.CAM_Z_BOW = 1.5;
        this.manager.CAM_X_BOW = 1.0;
        this.manager.CAM_Y_BOW = 0.0;
        this.manager.CAM_SMOOTHING = 0.2;
        this.rows.forEach(row -> row.refreshLabel());
    }

    private void saveConfigToJson() {
        AdvancedCameraConfig cfg = AdvancedCameraClient.CONFIG;
        cfg.CAM_Z_DEFAULT = this.manager.CAM_Z_DEFAULT;
        cfg.CAM_X_DEFAULT = this.manager.CAM_X_DEFAULT;
        cfg.CAM_Y_DEFAULT = this.manager.CAM_Y_DEFAULT;
        cfg.CAM_Z_MEDIUM = this.manager.CAM_Z_MEDIUM;
        cfg.CAM_X_MEDIUM = this.manager.CAM_X_MEDIUM;
        cfg.CAM_Y_MEDIUM = this.manager.CAM_Y_MEDIUM;
        cfg.CAM_Z_LONG = this.manager.CAM_Z_LONG;
        cfg.CAM_X_LONG = this.manager.CAM_X_LONG;
        cfg.CAM_Y_LONG = this.manager.CAM_Y_LONG;
        cfg.CAM_Z_DEFAULT_HORSE = this.manager.CAM_Z_DEFAULT_HORSE;
        cfg.CAM_Z_BOW = this.manager.CAM_Z_BOW;
        cfg.CAM_X_BOW = this.manager.CAM_X_BOW;
        cfg.CAM_Y_BOW = this.manager.CAM_Y_BOW;
        cfg.CAM_SMOOTHING = this.manager.CAM_SMOOTHING;
        cfg.save();
    }

    public void method_25419() {
        this.saveConfigToJson();
        super.method_25419();
    }

    private void updateMaxScroll() {
        int visibleHeight = this.field_22790 - 20 - 80;
        this.maxScroll = Math.max(0.0, (double)(this.contentHeight - visibleHeight));
        if (this.scrollY > this.maxScroll) {
            this.scrollY = this.maxScroll;
        }
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        this.updateMaxScroll();
        int visibleTop = 20;
        int visibleBottom = this.field_22790 - 80;
        for (Row row : this.rows) {
            boolean visible;
            int drawY = (int)((double)row.baseY - this.scrollY);
            row.minus.field_22764 = visible = drawY + 20 >= visibleTop && drawY <= visibleBottom;
            row.label.field_22764 = visible;
            row.plus.field_22764 = visible;
            row.minus.method_46419(drawY);
            row.label.method_46419(drawY);
            row.plus.method_46419(drawY);
        }
        if (this.maxScroll > 0.0) {
            int barX1 = this.field_22789 - 6;
            int barX0 = barX1 - 4;
            int areaHeight = visibleBottom - visibleTop;
            int barHeight = Math.max(20, (int)((double)areaHeight * ((double)areaHeight / (double)this.contentHeight)));
            int barY = visibleTop + (int)(this.scrollY / this.maxScroll * (double)(areaHeight - barHeight));
            graphics.method_25294(barX0, barY, barX1, barY + barHeight, -2130706433);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.maxScroll > 0.0) {
            this.scrollY -= verticalAmount * 10.0;
            if (this.scrollY < 0.0) {
                this.scrollY = 0.0;
            }
            if (this.scrollY > this.maxScroll) {
                this.scrollY = this.maxScroll;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Environment(value=EnvType.CLIENT)
    private static class Row {
        final int baseY;
        final class_4185 minus;
        final class_4185 label;
        final class_4185 plus;

        Row(int baseY, class_4185 minus, class_4185 label, class_4185 plus) {
            this.baseY = baseY;
            this.minus = minus;
            this.label = label;
            this.plus = plus;
        }

        void refreshLabel() {
        }
    }
}

