/*
 * Decompiled with CFR 0.152.
 */
package com.lostmortal.advancedcamera;

import com.lostmortal.advancedcamera.AdvancedCameraConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CameraPositionManager {
    private static final int PRESET_DEFAULT = 0;
    private static final int PRESET_MEDIUM = 1;
    private static final int PRESET_LONG = 2;
    public double CAM_Z_DEFAULT = 4.0;
    public double CAM_Z_MEDIUM = 8.0;
    public double CAM_Z_LONG = 12.0;
    public double CAM_Z_DEFAULT_HORSE = 1.0;
    public double CAM_X_DEFAULT = 0.0;
    public double CAM_X_MEDIUM = 0.0;
    public double CAM_X_LONG = 0.0;
    public double CAM_Y_DEFAULT = 0.0;
    public double CAM_Y_MEDIUM = 3.0;
    public double CAM_Y_LONG = 6.0;
    public double CAM_Z_BOW = 1.5;
    public double CAM_X_BOW = -0.75;
    public double CAM_Y_BOW = 0.25;
    public double CAM_SMOOTHING = 0.2;
    private int preset = 0;

    public void cyclePreset() {
        this.preset = (this.preset + 1) % 3;
    }

    public double getZ() {
        return switch (this.preset) {
            case 1 -> this.CAM_Z_MEDIUM;
            case 2 -> this.CAM_Z_LONG;
            default -> this.CAM_Z_DEFAULT;
        };
    }

    public double getX() {
        return switch (this.preset) {
            case 1 -> this.CAM_X_MEDIUM;
            case 2 -> this.CAM_X_LONG;
            default -> this.CAM_X_DEFAULT;
        };
    }

    public double getY() {
        return switch (this.preset) {
            case 1 -> this.CAM_Y_MEDIUM;
            case 2 -> this.CAM_Y_LONG;
            default -> this.CAM_Y_DEFAULT;
        };
    }

    public boolean isDefaultPreset() {
        return this.preset == 0;
    }

    public void invertCurrentX(boolean combatMode) {
        if (combatMode) {
            this.CAM_X_BOW = -this.CAM_X_BOW;
            return;
        }
        switch (this.preset) {
            case 1: {
                this.CAM_X_MEDIUM = -this.CAM_X_MEDIUM;
                break;
            }
            case 2: {
                this.CAM_X_LONG = -this.CAM_X_LONG;
                break;
            }
            default: {
                this.CAM_X_DEFAULT = -this.CAM_X_DEFAULT;
            }
        }
    }

    public void applyConfig(AdvancedCameraConfig cfg) {
        this.CAM_Z_DEFAULT = cfg.CAM_Z_DEFAULT;
        this.CAM_X_DEFAULT = cfg.CAM_X_DEFAULT;
        this.CAM_Y_DEFAULT = cfg.CAM_Y_DEFAULT;
        this.CAM_Z_MEDIUM = cfg.CAM_Z_MEDIUM;
        this.CAM_X_MEDIUM = cfg.CAM_X_MEDIUM;
        this.CAM_Y_MEDIUM = cfg.CAM_Y_MEDIUM;
        this.CAM_Z_LONG = cfg.CAM_Z_LONG;
        this.CAM_X_LONG = cfg.CAM_X_LONG;
        this.CAM_Y_LONG = cfg.CAM_Y_LONG;
        this.CAM_Z_DEFAULT_HORSE = cfg.CAM_Z_DEFAULT_HORSE;
        this.CAM_Z_BOW = cfg.CAM_Z_BOW;
        this.CAM_X_BOW = cfg.CAM_X_BOW;
        this.CAM_Y_BOW = cfg.CAM_Y_BOW;
        this.CAM_SMOOTHING = cfg.CAM_SMOOTHING;
    }
}

