/*
 * Decompiled with CFR 0.152.
 */
package com.lostmortal.advancedcamera.mixin.client;

import com.lostmortal.advancedcamera.AdvancedCameraClient;
import com.lostmortal.advancedcamera.CameraPositionManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_4184.class})
public abstract class CameraMixin {
    @Shadow
    private class_1297 field_18711;
    private boolean advancedcamera$initialized = false;
    private double advancedcamera$smoothedDistance;
    private double advancedcamera$smoothedHorseExtra;
    private double advancedcamera$smoothedYOffset;
    private double advancedcamera$smoothedXOffset;
    private class_243 advancedcamera$lastThirdPersonPos;
    private boolean advancedcamera$transitionToFirst = false;
    private int advancedcamera$transitionTicks = 0;
    private static final int ADVANCEDCAMERA_FIRST_TRANSITION_TICKS = 8;

    @Shadow
    public abstract class_243 method_19326();

    @Shadow
    protected abstract void method_19322(class_243 var1);

    @Inject(method={"method_19321(Lnet/minecraft/class_1922;Lnet/minecraft/class_1297;ZZF)V"}, at={@At(value="TAIL")})
    private void advancedcamera$applyPresets(class_1922 level, class_1297 entity, boolean thirdPerson, boolean reverseView, float partialTick, CallbackInfo ci) {
        double hitDist;
        class_243 desiredOffset;
        double desiredLen;
        class_1297 vehicle;
        double targetXOffset;
        double targetYOffset;
        double baseTargetDist;
        if (!thirdPerson) {
            int maxTicks;
            double t;
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1690.method_31044() != class_5498.field_26664) {
                this.advancedcamera$initialized = false;
                this.advancedcamera$transitionToFirst = false;
                this.advancedcamera$lastThirdPersonPos = null;
                return;
            }
            class_1297 e = this.field_18711;
            if (e == null) {
                this.advancedcamera$initialized = false;
                this.advancedcamera$transitionToFirst = false;
                this.advancedcamera$lastThirdPersonPos = null;
                return;
            }
            class_243 eyePos = e.method_5836(partialTick);
            if (this.advancedcamera$lastThirdPersonPos == null) {
                this.advancedcamera$initialized = false;
                this.advancedcamera$transitionToFirst = false;
                return;
            }
            if (!this.advancedcamera$transitionToFirst) {
                this.advancedcamera$transitionToFirst = true;
                this.advancedcamera$transitionTicks = 0;
            }
            if ((t = (double)this.advancedcamera$transitionTicks / (double)(maxTicks = 8)) >= 1.0) {
                this.advancedcamera$transitionToFirst = false;
                this.advancedcamera$lastThirdPersonPos = null;
                this.advancedcamera$initialized = false;
                this.method_19322(eyePos);
                return;
            }
            double eased = 1.0 - (1.0 - t) * (1.0 - t);
            class_243 from = this.advancedcamera$lastThirdPersonPos;
            class_243 blended = from.method_35590(eyePos, eased);
            this.method_19322(blended);
            ++this.advancedcamera$transitionTicks;
            return;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1690.method_31044() == class_5498.field_26664) {
            this.advancedcamera$initialized = false;
            return;
        }
        CameraPositionManager manager = AdvancedCameraClient.CAMERA_POSITION_MANAGER;
        class_1297 e = this.field_18711;
        if (e == null) {
            return;
        }
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_243 eyePos = e.method_5836(partialTick);
        class_243 currentPos = this.method_19326();
        class_243 offset = currentPos.method_1020(eyePos);
        double currentDist = offset.method_1033();
        if (currentDist < 0.001) {
            return;
        }
        class_243 dir = offset.method_1029();
        boolean combatMode = false;
        if (e instanceof class_1309) {
            class_1309 living = (class_1309)e;
            class_1799 main = living.method_6047();
            class_1799 off = living.method_6079();
            boolean bl = combatMode = main.method_7909() instanceof class_1753 || off.method_7909() instanceof class_1753;
        }
        if (combatMode) {
            baseTargetDist = manager.CAM_Z_BOW;
            targetYOffset = manager.CAM_Y_BOW;
            targetXOffset = manager.CAM_X_BOW;
        } else {
            baseTargetDist = manager.getZ();
            targetYOffset = manager.getY();
            targetXOffset = manager.getX();
        }
        if (baseTargetDist <= 0.0) {
            return;
        }
        double targetHorseExtra = 0.0;
        if (!combatMode && (vehicle = e.method_5854()) instanceof class_1496 && manager.isDefaultPreset()) {
            targetHorseExtra = manager.CAM_Z_DEFAULT_HORSE;
        }
        if (!this.advancedcamera$initialized) {
            this.advancedcamera$smoothedDistance = baseTargetDist;
            this.advancedcamera$smoothedHorseExtra = targetHorseExtra;
            this.advancedcamera$smoothedYOffset = targetYOffset;
            this.advancedcamera$smoothedXOffset = targetXOffset;
            this.advancedcamera$initialized = true;
        } else {
            double a = manager.CAM_SMOOTHING;
            if (a < 0.01) {
                a = 0.01;
            }
            if (a > 1.0) {
                a = 1.0;
            }
            this.advancedcamera$smoothedDistance += (baseTargetDist - this.advancedcamera$smoothedDistance) * a;
            this.advancedcamera$smoothedHorseExtra += (targetHorseExtra - this.advancedcamera$smoothedHorseExtra) * a;
            this.advancedcamera$smoothedYOffset += (targetYOffset - this.advancedcamera$smoothedYOffset) * a;
            this.advancedcamera$smoothedXOffset += (targetXOffset - this.advancedcamera$smoothedXOffset) * a;
        }
        double effectiveDistance = this.advancedcamera$smoothedDistance + this.advancedcamera$smoothedHorseExtra;
        double dx = dir.field_1352 * effectiveDistance;
        double dy = dir.field_1351 * effectiveDistance;
        double dz = dir.field_1350 * effectiveDistance;
        double xOffset = this.advancedcamera$smoothedXOffset;
        if (xOffset != 0.0) {
            double rz;
            double ry;
            float yawRad = (float)Math.toRadians(e.method_36454());
            double fx = -Math.sin(yawRad);
            double fz = Math.cos(yawRad);
            double rx = -fz;
            double len = Math.sqrt(rx * rx + (ry = 0.0) * ry + (rz = fx) * rz);
            if (len > 1.0E-4) {
                dx += (rx /= len) * xOffset;
                dy += (ry /= len) * xOffset;
                dz += (rz /= len) * xOffset;
            }
        }
        if (this.advancedcamera$smoothedYOffset != 0.0) {
            dy += this.advancedcamera$smoothedYOffset;
        }
        if ((desiredLen = (desiredOffset = new class_243(dx, dy, dz)).method_1033()) < 0.001) {
            this.method_19322(eyePos);
            return;
        }
        class_243 desiredEnd = eyePos.method_1019(desiredOffset);
        class_3965 hit = world.method_17742(new class_3959(eyePos, desiredEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, e));
        double scale = 1.0;
        if (hit.method_17783() != class_239.class_240.field_1333 && (hitDist = hit.method_17784().method_1022(eyePos) - 0.3) < desiredLen) {
            scale = hitDist <= 0.0 ? 0.0 : hitDist / desiredLen;
        }
        class_243 finalOffset = desiredOffset.method_1021(scale);
        class_243 finalPos = eyePos.method_1019(finalOffset);
        this.method_19322(finalPos);
        this.advancedcamera$lastThirdPersonPos = finalPos;
        this.advancedcamera$transitionToFirst = false;
        this.advancedcamera$transitionTicks = 0;
    }
}

