/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.arcana.friendsforlife.Commands;
import net.arcana.friendsforlife.Net;
import net.arcana.friendsforlife.Packets;
import net.arcana.friendsforlife.Sounds;
import net.arcana.friendsforlife.TameableWanderHelper;
import net.arcana.friendsforlife.TaskScheduler;
import net.arcana.friendsforlife.accessors.TameableEntityDecorator;
import net.arcana.friendsforlife.items.CollarItem;
import net.arcana.friendsforlife.items.Items;
import net.arcana.friendsforlife.items.OcarinaItem;
import net.arcana.friendsforlife.petdatabase.OcarinaRegistry;
import net.arcana.friendsforlife.petdatabase.PetData;
import net.arcana.friendsforlife.petdatabase.PetTracker;
import net.arcana.friendsforlife.petdatabase.PetWatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModInit
implements ModInitializer {
    public static final String MOD_ID = "friendsforlife";
    private final Map<UUID, Object> teleportLocks = new ConcurrentHashMap<UUID, Object>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"friendsforlife");

    public void onInitialize() {
        Items.register();
        Sounds.register();
        PetWatcher.register();
        Commands.register();
        Net.register();
        TaskScheduler.register();
        UseEntityCallback.EVENT.register((playerEntity, world, hand, entity, entityHitResult) -> {
            if (entityHitResult != null) {
                return class_1269.field_5811;
            }
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (entity instanceof class_1321) {
                class_1321 tame = (class_1321)entity;
                if (!tame.method_6171((class_1309)playerEntity)) {
                    return class_1269.field_5811;
                }
                class_1799 stack = playerEntity.method_5998(hand);
                PetTracker tracker = PetTracker.get(playerEntity.method_5682());
                PetData pd = tracker.get(((TameableEntityDecorator)tame).friendsforlife_getUuid());
                class_1792 patt3097$temp = stack.method_7909();
                if (patt3097$temp instanceof CollarItem) {
                    CollarItem collarItem = (CollarItem)patt3097$temp;
                    if (pd == null) {
                        return collarItem.applyCollar(stack, (class_3222)playerEntity, tame);
                    }
                }
                if (stack.method_7960() && playerEntity.method_5715()) {
                    class_1799 collar = CollarItem.getCollar(playerEntity, tame, pd);
                    if (collar == null) {
                        return class_1269.field_5811;
                    }
                    if (pd == null) {
                        LOGGER.error(MOD_ID, (Object)("Unable to find PetData for tracked entity " + tame.method_5845()));
                        return class_1269.field_5811;
                    }
                    CollarItem.removePet(tame, pd);
                    playerEntity.method_7270(collar);
                    return class_1269.field_21466;
                }
                class_1792 patt3944$temp = stack.method_7909();
                if (patt3944$temp instanceof OcarinaItem) {
                    OcarinaItem ocarina = (OcarinaItem)patt3944$temp;
                    if (pd != null) {
                        return ocarina.useOcarinaFromPet(world, playerEntity, stack, pd, tame);
                    }
                }
            }
            return class_1269.field_5811;
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.REQUEST_PET_TRACKER, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            class_2540 petList = PetTracker.serializePetList(server);
            ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.RESPONSE_PET_TRACKER, (class_2540)petList);
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.REQUEST_PET_TELEPORT, (server, player, handler, buf, responseSender) -> {
            try {
                UUID petUuid = buf.method_10790();
                int x = buf.readInt();
                int y = buf.readInt();
                int z = buf.readInt();
                class_2960 dim = buf.method_10810();
                Boolean shouldWander = buf.readBoolean();
                server.execute(() -> {
                    Object lock;
                    Object object = lock = this.teleportLocks.computeIfAbsent(petUuid, k -> new Object());
                    synchronized (object) {
                        PetTracker tracker = PetTracker.get(server);
                        PetData petData = tracker.getTrackedMap().get(petUuid);
                        class_1321 entity = null;
                        class_5321 targetWorldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dim);
                        if (petData != null) {
                            entity = petData.recreateEntity(server, (class_5321<class_1937>)targetWorldKey, x, y, z);
                            if (entity == null) {
                                LOGGER.error(MOD_ID, (Object)("Failed to recreate entity for pet UUID: " + String.valueOf(petUuid)));
                                return;
                            }
                            if (shouldWander.booleanValue()) {
                                TameableWanderHelper.makeTameableWander(entity);
                            } else {
                                entity.method_24346(false);
                                TameableWanderHelper.stopWandering(entity);
                            }
                        } else {
                            LOGGER.error(MOD_ID, (Object)("No pet data found for UUID: " + String.valueOf(petUuid)));
                        }
                        this.teleportLocks.remove(petUuid);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(MOD_ID, (Object)("Bad summon packet from " + player.method_5477().getString() + ": " + String.valueOf(e)));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.REQUEST_OCARINA_REGISTRY, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            class_2540 ocarinaList = OcarinaRegistry.get(server).serializeList();
            ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.REQUEST_OCARINA_REGISTRY, (class_2540)ocarinaList);
        }));
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            PetTracker tracker;
            Set<UUID> recreatedSet;
            if (entity instanceof class_1321 && (recreatedSet = (tracker = PetTracker.get(world.method_8503())).getRecreatedMap()).remove(entity.method_5667())) {
                tracker.method_80();
                world.method_8503().execute(() -> entity.method_31472());
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (entity instanceof class_1321) {
                PetTracker tracker;
                PetData pd;
                class_1321 tame = (class_1321)entity;
                if (!world.field_9236 && (pd = (tracker = PetTracker.get(world.method_8503())).getByEntityId(tame.method_5667())) != null) {
                    pd.updateEntityData(nbt -> tame.method_5647(nbt));
                }
            }
        });
    }
}

