/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.client;

import io.netty.buffer.Unpooled;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.arcana.friendsforlife.ModInit;
import net.arcana.friendsforlife.Packets;
import net.arcana.friendsforlife.client.ClientHomeBlock;
import net.arcana.friendsforlife.client.ClientPetData;
import net.arcana.friendsforlife.client.ClientPetList;
import net.arcana.friendsforlife.homeblock.HomeBlockUpdateEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class RosterScreen
extends BaseUIModelScreen<StackLayout> {
    private int currentPetIndex;
    private EntityComponent<class_1297> entityBox;
    @Nullable
    private StackLayout entityBoxContainer;
    private ClientPetData currentPet;
    @Nullable
    private ButtonComponent homeButton;
    @Nullable
    private LabelComponent homeLabel;
    @Nullable
    private LabelComponent defaultHomeLabel;
    private HomeBlockUpdateEvents.IListener homeUpdateListener;
    @Nullable
    private ButtonComponent summonButton;
    private List<ClientPetData> pets;

    public RosterScreen() {
        super(StackLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)new class_2960("friendsforlife", "roster")));
    }

    protected void method_25426() {
        super.method_25426();
        class_2540 buf = new class_2540(Unpooled.buffer());
        ClientPlayNetworking.send((class_2960)Packets.REQUEST_PET_TRACKER, (class_2540)buf);
        this.homeLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "home-position-label");
        this.homeButton = (ButtonComponent)((StackLayout)this.uiAdapter.rootComponent).childById(ButtonComponent.class, "home-button");
        this.defaultHomeLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "default-home-label");
        this.homeUpdateListener = (uuid, newHomePos, newDim) -> {
            class_746 player = class_310.method_1551().field_1724;
            if (uuid.equals(player.method_5667())) {
                if (this.currentPet != null && this.currentPet.homePosition == null) {
                    this.homeLabel.text((class_2561)class_2561.method_43470((String)newHomePos.method_23854()));
                    this.homeButton.field_22764 = true;
                }
                this.defaultHomeLabel.text((class_2561)class_2561.method_43470((String)newHomePos.method_23854()));
            }
        };
        HomeBlockUpdateEvents.subscribe(this.homeUpdateListener);
        class_2338 homePos = null;
        homePos = this.currentPet != null && this.currentPet.homePosition != null && this.currentPet.homeDimension != null ? this.currentPet.homePosition : ClientHomeBlock.get();
        if (this.currentPet != null) {
            this.homeLabel.text((class_2561)class_2561.method_43470((String)homePos.method_23854()));
            this.homeButton.field_22764 = true;
        } else {
            this.homeLabel.text((class_2561)class_2561.method_43470((String)""));
        }
        class_2338 defaultHomePos = ClientHomeBlock.get();
        this.defaultHomeLabel.text((class_2561)class_2561.method_43470((String)defaultHomePos.method_23854()));
        ClientPetList.addListener(this::fetchPetList);
        this.entityBoxContainer = (StackLayout)((StackLayout)this.uiAdapter.rootComponent).childById(StackLayout.class, "entity-box-container");
        this.field_22787.execute(() -> this.fetchPetList());
    }

    protected void build(StackLayout rootComponent) {
        StackLayout container;
        this.summonButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, "summon-button");
        this.summonButton.onPress(button -> {
            if (this.currentPet == null) {
                ModInit.LOGGER.error("friendsforlife", (Object)"Unable to find current pet.");
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return;
            }
            class_2338 pos = mc.field_1724.method_24515();
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            boolean shouldSit = false;
            class_2960 dim = mc.field_1724.method_37908().method_27983().method_29177();
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.currentPet.uuid);
            buf.writeInt(x);
            buf.writeInt(y);
            buf.writeInt(z);
            buf.method_10812(dim);
            buf.writeBoolean(shouldSit);
            ClientPlayNetworking.send((class_2960)Packets.REQUEST_PET_TELEPORT, (class_2540)buf);
        });
        this.summonButton.field_22764 = this.currentPet != null;
        this.homeButton = (ButtonComponent)((StackLayout)this.uiAdapter.rootComponent).childById(ButtonComponent.class, "home-button");
        this.homeLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "home-position-label");
        boolean bl = this.homeButton.field_22764 = this.currentPet != null;
        if (this.currentPet == null) {
            this.homeLabel.text((class_2561)class_2561.method_43470((String)""));
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            this.homeButton.onPress(button -> {
                class_2338 homePos = null;
                class_2960 dimId = null;
                if (this.currentPet.homePosition != null && this.currentPet.homeDimension != null) {
                    homePos = this.currentPet.homePosition;
                    dimId = this.currentPet.homeDimension;
                } else {
                    homePos = ClientHomeBlock.get();
                    dimId = ClientHomeBlock.getDimKey().method_29177();
                }
                if (homePos == null) {
                    return;
                }
                assert (this.currentPet != null);
                int x = homePos.method_10263();
                int y = homePos.method_10264();
                int z = homePos.method_10260();
                boolean shouldWander = true;
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10797(this.currentPet.uuid);
                buf.writeInt(x);
                buf.writeInt(y);
                buf.writeInt(z);
                buf.method_10812(dimId);
                buf.writeBoolean(shouldWander);
                ClientPlayNetworking.send((class_2960)Packets.REQUEST_PET_TELEPORT, (class_2540)buf);
            });
        }
        if (!(container = (StackLayout)rootComponent.childById(StackLayout.class, "entity-box-container")).children().isEmpty()) {
            container.removeChild((Component)container.children().get(0));
        }
        if (this.entityBox != null) {
            this.entityBox.lookAtCursor(true);
            this.entityBox.scaleToFit(true);
            container.child(this.entityBox);
        }
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "close-button")).onPress(button -> this.method_25419());
    }

    @Nullable
    protected void updateCurrentPet(ClientPetData newPet) {
        EntityComponent newEntityBox;
        if (newPet == null) {
            this.currentPet = null;
            this.currentPetIndex = -1;
            this.summonButton.field_22764 = false;
            this.homeButton.field_22764 = false;
            return;
        }
        assert (this.pets != null);
        this.currentPetIndex = this.pets.indexOf(newPet);
        this.currentPet = newPet;
        this.summonButton.field_22764 = true;
        this.homeButton.field_22764 = true;
        this.entityBoxContainer.removeChild(this.entityBox);
        this.entityBox = newEntityBox = Components.entity((Sizing)Sizing.fixed((int)50), newPet.type, (class_2487)newPet.getRenderingEntity((class_1937)class_310.method_1551().field_1687).method_5647(new class_2487()));
        this.entityBoxContainer.child(this.entityBox);
        newEntityBox.lookAtCursor(true);
        newEntityBox.scaleToFit(true);
        LabelComponent nameLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "pet-name-label");
        String clipped = class_310.method_1551().field_1772.method_27523(class_2561.method_43470((String)newPet.name).getString(), nameLabel.maxWidth());
        nameLabel.text((class_2561)class_2561.method_43470((String)clipped));
        nameLabel.tooltip((class_2561)class_2561.method_43470((String)newPet.name));
        LabelComponent positionLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "pet-position-label");
        positionLabel.text((class_2561)class_2561.method_43470((String)newPet.position));
        this.homeLabel = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "home-position-label");
        class_2338 homePos = null;
        homePos = this.currentPet.homePosition != null ? this.currentPet.homePosition : ClientHomeBlock.get();
        this.homeLabel.text((class_2561)class_2561.method_43470((String)homePos.method_23854()));
    }

    public void setPets(List<ClientPetData> pets) {
        if (pets.isEmpty()) {
            this.updateCurrentPet(null);
            return;
        }
        this.pets = pets;
        this.updateCurrentPet(pets.get(0));
        LabelComponent noPetsMessage = (LabelComponent)((StackLayout)this.uiAdapter.rootComponent).childById(LabelComponent.class, "no-pets-message");
        if (noPetsMessage != null) {
            noPetsMessage.remove();
        }
        FlowLayout petListContainer = (FlowLayout)((StackLayout)this.uiAdapter.rootComponent).childById(FlowLayout.class, "pet-list");
        petListContainer.clearChildren();
        for (ClientPetData pet : pets) {
            int normalBg = 0;
            int hoverBg = -1;
            Color normalText = Color.ofDye((class_1767)class_1767.field_7952);
            Color hoverText = Color.ofDye((class_1767)class_1767.field_7957);
            StackLayout wrapper = Containers.stack((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content());
            wrapper.surface(Surface.flat((int)normalBg));
            LabelComponent label = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)(" " + pet.name))).cursorStyle(CursorStyle.HAND).horizontalSizing(Sizing.fill((int)100)).margins(Insets.vertical((int)2));
            label.mouseDown().subscribe((mouseX, mouseY, button) -> {
                if (button == 0) {
                    this.updateCurrentPet(pet);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    return true;
                }
                return false;
            });
            label.mouseEnter().subscribe(() -> {
                label.color(hoverText);
                wrapper.surface(Surface.flat((int)hoverBg));
            });
            label.mouseLeave().subscribe(() -> {
                label.color(normalText);
                wrapper.surface(Surface.flat((int)normalBg));
            });
            wrapper.child((Component)label);
            petListContainer.child((Component)wrapper);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
        ClientPetList.removeListener(this::fetchPetList);
        HomeBlockUpdateEvents.unsubscribe(this.homeUpdateListener);
    }

    private void fetchPetList() {
        List<ClientPetData> pets = ClientPetList.getAllForPlayer(class_310.method_1551().field_1724);
        this.setPets(pets);
    }
}

