/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.homeblock;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.arcana.friendsforlife.ModInit;
import net.arcana.friendsforlife.Net;
import net.arcana.friendsforlife.packets.HomeUpdatePacket;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class HomeBlock
extends class_18 {
    private final Map<UUID, HomeBlockHandle> playerHomes = new HashMap<UUID, HomeBlockHandle>();
    public static final String KEY = "friendsforlife_home_blocks";

    public static HomeBlock get(MinecraftServer server) {
        class_26 manager = server.method_30002().method_17983();
        return (HomeBlock)manager.method_17924(HomeBlock::fromNbt, HomeBlock::new, KEY);
    }

    public static HomeBlock fromNbt(class_2487 nbt) {
        HomeBlock state = new HomeBlock();
        class_2487 homes = nbt.method_10562("Homes");
        for (String key : homes.method_10541()) {
            try {
                UUID uuid = UUID.fromString(key);
                class_2487 posTag = homes.method_10562(key);
                class_2338 pos = new class_2338(posTag.method_10550("x"), posTag.method_10550("y"), posTag.method_10550("z"));
                String dimStr = posTag.method_10558("dimension");
                class_5321 dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimStr));
                state.playerHomes.put(uuid, new HomeBlockHandle(pos, (class_5321<class_1937>)dim));
            }
            catch (Exception e) {
                ModInit.LOGGER.error("friendsforlife", (Object)("Skipped invalid home entry: " + key));
            }
        }
        return state;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 homes = new class_2487();
        for (Map.Entry<UUID, HomeBlockHandle> e : this.playerHomes.entrySet()) {
            class_2338 pos = e.getValue().pos();
            class_5321<class_1937> dim = e.getValue().dim();
            class_2487 tag = new class_2487();
            tag.method_10569("x", pos.method_10263());
            tag.method_10569("y", pos.method_10264());
            tag.method_10569("z", pos.method_10260());
            tag.method_10582("dimension", dim.method_29177().toString());
            homes.method_10566(e.getKey().toString(), (class_2520)tag);
        }
        nbt.method_10566("Homes", (class_2520)homes);
        return nbt;
    }

    public void setHome(class_3222 player, class_2338 pos, class_5321<class_1937> dim) {
        this.playerHomes.put(player.method_5667(), new HomeBlockHandle(pos, dim));
        Net.CHANNEL.serverHandle((class_1657)player).send((Record)new HomeUpdatePacket(pos, dim.method_29177()));
        this.method_80();
    }

    @Nullable
    public HomeBlockHandle getHome(MinecraftServer server, UUID playerUuid) {
        class_3222 player;
        HomeBlockHandle home = this.playerHomes.get(playerUuid);
        if (home == null && (player = server.method_3760().method_14602(playerUuid)) != null) {
            home = new HomeBlockHandle(player.method_26280(), (class_5321<class_1937>)player.method_26281());
        }
        if (home.pos() == null) {
            home = new HomeBlockHandle(server.method_30002().method_43126(), (class_5321<class_1937>)server.method_30002().method_27983());
        }
        return home;
    }

    public boolean hasHome(UUID playerUuid) {
        return this.playerHomes.containsKey(playerUuid);
    }

    public void removeHome(class_3222 player) {
        if (this.playerHomes.remove(player.method_5667()) != null) {
            Net.CHANNEL.serverHandle((class_1657)player).send((Record)new HomeUpdatePacket(null, null));
            this.method_80();
        }
    }

    public record HomeBlockHandle(class_2338 pos, class_5321<class_1937> dim) {
    }
}

