/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.items;

import java.util.List;
import java.util.UUID;
import net.arcana.friendsforlife.RaycastHelper;
import net.arcana.friendsforlife.Sounds;
import net.arcana.friendsforlife.TameableWanderHelper;
import net.arcana.friendsforlife.TaskScheduler;
import net.arcana.friendsforlife.client.ClientOcarinaRegistry;
import net.arcana.friendsforlife.client.ClientPetData;
import net.arcana.friendsforlife.client.ClientPetList;
import net.arcana.friendsforlife.homeblock.HomeBlock;
import net.arcana.friendsforlife.petdatabase.OcarinaRegistry;
import net.arcana.friendsforlife.petdatabase.PetData;
import net.arcana.friendsforlife.petdatabase.PetTracker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1321;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class OcarinaItem
extends class_1792 {
    public OcarinaItem(class_1792.class_1793 settings) {
        super(settings);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7886(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10545("ocarinaUuid")) {
            return false;
        }
        UUID ocarinaUuid = UUID.fromString(stack.method_7969().method_10558("ocarinaUuid"));
        return ClientOcarinaRegistry.hasPet(ocarinaUuid);
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 baseName = super.method_7864(stack);
        String name = this.getPetName(stack);
        if (!name.isEmpty()) {
            return class_2561.method_43470((String)(baseName.getString() + " - " + name));
        }
        return baseName;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!player.method_7357().method_7904((class_1792)this) && !world.field_9236) {
            class_2487 nbt = stack.method_7948();
            UUID ocarinaUuid = nbt.method_10545("ocarinaUuid") ? UUID.fromString(nbt.method_10558("ocarinaUuid")) : null;
            OcarinaRegistry registry = OcarinaRegistry.get(world.method_8503());
            UUID petUuid = registry.getPetForOcarina(ocarinaUuid);
            PetTracker tracker = PetTracker.get(world.method_8503());
            PetData petData = tracker.get(petUuid);
            if (!player.method_5715() && petUuid != null && petData != null) {
                class_2338 pos = RaycastHelper.getSafeBlock(player);
                TaskScheduler.schedule(() -> {
                    class_1321 tame = petData.recreateEntity(world.method_8503(), (class_5321<class_1937>)world.method_27983(), pos.method_10263(), pos.method_10264(), pos.method_10260());
                    if (tame != null) {
                        TameableWanderHelper.stopWandering(tame);
                    }
                }, 30);
            }
            if (player.method_5715() && registry.getPetForOcarina(ocarinaUuid) != null && registry.getPetForOcarina(ocarinaUuid).equals(petData.uuid)) {
                class_1321 tame;
                HomeBlock.HomeBlockHandle hbh = petData.getHomeBlock();
                if (hbh == null) {
                    hbh = HomeBlock.get(world.method_8503()).getHome(world.method_8503(), player.method_5667());
                }
                if (hbh != null && (tame = petData.recreateEntity(world.method_8503(), (class_5321<class_1937>)world.method_27983(), hbh.pos().method_10263(), hbh.pos().method_10264(), hbh.pos().method_10260())) != null) {
                    TameableWanderHelper.makeTameableWander(tame);
                }
            }
            if (player.method_5715()) {
                world.method_8396(null, player.method_24515(), Sounds.OCARINA_TWO, class_3419.field_15248, 0.7f, 1.0f);
            } else {
                world.method_8396(null, player.method_24515(), Sounds.OCARINA, class_3419.field_15248, 0.7f, 1.0f);
            }
            player.method_7357().method_7906((class_1792)this, 45);
        }
        return class_1271.method_22427((Object)player.method_5998(hand));
    }

    public class_1269 useOcarinaFromPet(class_1937 world, class_1657 player, class_1799 stack, PetData petData, class_1321 tame) {
        if (!player.method_7357().method_7904((class_1792)this)) {
            class_2487 nbt = stack.method_7948();
            UUID ocarinaUuid = nbt.method_10545("ocarinaUuid") ? UUID.fromString(nbt.method_10558("ocarinaUuid")) : null;
            OcarinaRegistry registry = OcarinaRegistry.get(world.method_8503());
            UUID petUuid = registry.getPetForOcarina(ocarinaUuid);
            if (player.method_5715()) {
                if (petUuid == null || !petUuid.equals(petData.uuid)) {
                    UUID ocarinaId;
                    UUID uUID = ocarinaId = nbt.method_10558("ocarinaUuid") != "" ? UUID.fromString(nbt.method_10558("ocarinaUuid")) : null;
                    if (!nbt.method_10545("ocarinaUuid")) {
                        ocarinaId = UUID.randomUUID();
                        nbt.method_10582("ocarinaUuid", ocarinaId.toString());
                    }
                    registry.register(ocarinaId, petData.uuid, world.method_8503());
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.friendsforlife.ocarina_bound"), true);
                    return class_1269.field_5812;
                }
                return this.method_7836(world, player, class_1268.field_5808).method_5467();
            }
        }
        return class_1269.field_5811;
    }

    public void method_33261(class_1542 entity) {
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        String name = this.getPetName(stack);
        if (!name.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075));
        }
        if (class_437.method_25442()) {
            List lines = class_7919.method_47406((class_310)class_310.method_1551(), (class_2561)class_2561.method_43471((String)"tooltip.friendsforlife.ocarina.info"));
            for (class_5481 line : lines) {
                StringBuilder sb = new StringBuilder();
                line.accept((index, style, codePoint) -> {
                    sb.appendCodePoint(codePoint);
                    return true;
                });
                tooltip.add((class_2561)class_2561.method_43470((String)sb.toString()).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.friendsforlife.more_info").method_27692(class_124.field_1080));
        }
    }

    private String getPetName(class_1799 stack) {
        ClientPetData pd;
        UUID ocarinaUuid;
        UUID petUuid;
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545("ocarinaUuid") && (petUuid = ClientOcarinaRegistry.getPet(ocarinaUuid = UUID.fromString(nbt.method_10558("ocarinaUuid")))) != null && (pd = ClientPetList.getPet(petUuid)) != null) {
            return pd.name;
        }
        return "";
    }
}

