/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.mixin;

import java.util.UUID;
import net.arcana.friendsforlife.accessors.TameableEntityDecorator;
import net.arcana.friendsforlife.petdatabase.PetData;
import net.arcana.friendsforlife.petdatabase.PetTracker;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1321.class})
public abstract class TameableEntityMixin
implements TameableEntityDecorator {
    private UUID friendsforlife_uuid = UUID.randomUUID();
    @Unique
    private boolean friendsforlife_forceWander = false;

    @Override
    public void friendsforlife_setUuid(UUID uuid) {
        this.friendsforlife_uuid = uuid;
    }

    @Override
    public UUID friendsforlife_getUuid() {
        return this.friendsforlife_uuid;
    }

    @Shadow
    @Nullable
    public abstract UUID method_6139();

    @Override
    public boolean friendsforlife_isForceWander() {
        return this.friendsforlife_forceWander;
    }

    @Override
    public void friendsforlife_setForceWander(boolean value) {
        this.friendsforlife_forceWander = value;
    }

    @Inject(method={"canTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void friendsforlife$disableCanBeAttackedIfPet(class_1309 target, CallbackInfoReturnable<Boolean> cir) {
        MinecraftServer server = target.method_37908().method_8503();
        if (server == null) {
            return;
        }
        PetData trackedPetData = PetTracker.get(server).get(((class_1321)this).method_5667());
        if (trackedPetData != null && target instanceof class_1657) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setSitting"}, at={@At(value="HEAD")})
    private void onSetSitting(boolean sitting, CallbackInfo ci) {
        this.friendsforlife_forceWander = false;
        class_1321 self = (class_1321)this;
        if (!self.method_37908().method_8608()) {
            MinecraftServer server = self.method_37908().method_8503();
            if (server == null) {
                return;
            }
            PetData data = PetTracker.get(server).get(this.friendsforlife_getUuid());
            if (data == null) {
                return;
            }
            ((class_3218)self.method_37908()).method_14199((class_2394)class_2398.field_11201, self.method_23317(), self.method_23323(1.0), self.method_23321(), 1, 0.3, 0.3, 0.3, 0.02);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeWanderStateToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("FriendsForLifeForceWander", this.friendsforlife_isForceWander());
        nbt.method_25927("FriendsForLifeEntityUUID", this.friendsforlife_getUuid());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readWanderStateFromNbt(class_2487 nbt, CallbackInfo ci) {
        UUID entityUuid;
        if (nbt.method_10545("FriendsForLifeForceWander")) {
            this.friendsforlife_setForceWander(nbt.method_10577("FriendsForLifeForceWander"));
        }
        if (nbt.method_10545("FriendsForLifeEntityUUID") && (entityUuid = nbt.method_25926("FriendsForLifeEntityUUID")) != null) {
            this.friendsforlife_setUuid(entityUuid);
        }
    }
}

