/*
 * Decompiled with CFR 0.152.
 */
package net.arcana.friendsforlife.petdatabase;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.arcana.friendsforlife.accessors.ShoulderAccessor;
import net.arcana.friendsforlife.accessors.TameableEntityDecorator;
import net.arcana.friendsforlife.homeblock.HomeBlock;
import net.arcana.friendsforlife.petdatabase.OcarinaRegistry;
import net.arcana.friendsforlife.petdatabase.PetTracker;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PetData {
    public final UUID uuid;
    public UUID entityUuid;
    public class_2338 position;
    public class_2487 collar;
    public final UUID ownerUuid;
    public final String OwnerName;
    public class_2338 homePosition;
    public class_5321<class_1937> homeDimension;
    public final long tameTimestamp;
    private class_2487 entityData;

    public class_2487 getEntityData() {
        return this.entityData;
    }

    public PetData(class_1321 tame, class_1297 player, class_2487 collarItem, long tameDate) {
        this.uuid = ((TameableEntityDecorator)tame).friendsforlife_getUuid();
        this.entityUuid = tame.method_5667();
        this.position = tame.method_24515();
        this.OwnerName = player.method_5820();
        this.ownerUuid = player.method_5667();
        this.collar = collarItem;
        this.entityData = new class_2487();
        tame.method_5786(this.entityData);
        this.entityData.method_10582("EntityType", tame.method_5864().toString());
        this.tameTimestamp = tameDate;
    }

    public PetData(UUID friendsforlifeUuid, class_2338 pos, UUID OwnerUuid, String OwnerName, class_2487 collarItem, long tameDate, class_2338 homePosition, class_5321<class_1937> homeDimension, class_2487 entityData) {
        this.entityUuid = this.uuid = friendsforlifeUuid;
        this.position = pos;
        this.OwnerName = OwnerName;
        this.ownerUuid = OwnerUuid;
        this.collar = collarItem;
        this.tameTimestamp = tameDate;
        this.homeDimension = homeDimension;
        this.homePosition = homePosition;
        this.entityData = entityData;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_25927("FriendsForLifeEntityUUID", this.uuid);
        tag.method_25927("OwnerUuid", this.ownerUuid);
        tag.method_10582("OwnerName", this.OwnerName);
        tag.method_10566("collarItem", (class_2520)this.collar);
        tag.method_10569("x", this.position.method_10263());
        tag.method_10569("y", this.position.method_10264());
        tag.method_10569("z", this.position.method_10260());
        tag.method_10544("tameDate", this.tameTimestamp);
        tag.method_10544("homePos", this.homePosition != null ? this.homePosition.method_10063() : 0L);
        tag.method_10582("homeDim", this.homeDimension != null ? this.homeDimension.method_29177().toString() : "");
        tag.method_10566("EntityData", (class_2520)this.entityData);
        return tag;
    }

    @Nullable
    public static PetData fromNbt(class_2487 tag) {
        if (tag == null) {
            return null;
        }
        UUID friendsforlife_uuid = tag.method_25926("FriendsForLifeEntityUUID");
        UUID OwnerUuid = tag.method_25926("OwnerUuid");
        String OwnerName = tag.method_10558("OwnerName");
        class_2487 collarItem = tag.method_10562("collarItem");
        class_2338 pos = new class_2338(tag.method_10550("x"), tag.method_10550("y"), tag.method_10550("z"));
        long tameDate = tag.method_10537("tameDate");
        class_2338 homePos = tag.method_10545("homePos") ? class_2338.method_10092((long)tag.method_10537("homePos")) : null;
        class_5321 homeDim = tag.method_10545("homeDim") && !tag.method_10558("homeDim").isEmpty() ? class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558("homeDim"))) : null;
        ArrayList<UUID> ocarinas = new ArrayList<UUID>();
        class_2499 ocarinaList = tag.method_10554("boundOcarinas", 10);
        for (class_2520 e : ocarinaList) {
            class_2487 ocarinaNbt = (class_2487)e;
            if (!ocarinaNbt.method_25928("uuid")) continue;
            ocarinas.add(ocarinaNbt.method_25926("uuid"));
        }
        class_2487 entityData = tag.method_10545("EntityData") ? tag.method_10562("EntityData") : null;
        return new PetData(friendsforlife_uuid, pos, OwnerUuid, OwnerName, collarItem, tameDate, homePos, (class_5321<class_1937>)homeDim, entityData);
    }

    public void updateEntityData(Consumer<class_2487> editor) {
        if (this.entityData == null) {
            return;
        }
        editor.accept(this.entityData);
    }

    @Nullable
    public HomeBlock.HomeBlockHandle getHomeBlock() {
        if (this.homePosition == null || this.homeDimension == null) {
            return null;
        }
        return new HomeBlock.HomeBlockHandle(this.homePosition, this.homeDimension);
    }

    public String getName() {
        if (this.entityData.method_10545("CustomName")) {
            return class_2561.class_2562.method_10877((String)this.entityData.method_10558("CustomName")).getString();
        }
        if (this.entityData.method_10545("EntityType")) {
            return this.entityData.method_10558("EntityType");
        }
        return "Unknown Pet";
    }

    public CompletableFuture<PetEntityHandle> getEntity(MinecraftServer server) {
        if (server == null) {
            return CompletableFuture.completedFuture(null);
        }
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_14190(this.entityUuid);
            if (entity == null) continue;
            return CompletableFuture.completedFuture(new PetEntityHandle((class_1321)entity, null));
        }
        for (class_3218 world : server.method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                TameableEntityDecorator data;
                class_1321 tame;
                if (!(entity instanceof class_1321) || !((tame = (class_1321)entity) instanceof TameableEntityDecorator) || !(data = (TameableEntityDecorator)tame).friendsforlife_getUuid().equals(this.uuid)) continue;
                return CompletableFuture.completedFuture(new PetEntityHandle(tame, null));
            }
        }
        class_3222 player = server.method_3760().method_14602(this.ownerUuid);
        if (player != null) {
            class_2487 left = player.method_7356();
            class_2487 right = player.method_7308();
            for (class_2487 nbt : List.of(left, right)) {
                if (nbt == null || nbt.method_33133() || !this.entityDataMatchesShoulder(nbt, this.entityData)) continue;
                return CompletableFuture.completedFuture(new PetEntityHandle(null, nbt));
            }
        }
        return CompletableFuture.completedFuture(new PetEntityHandle(null, null));
    }

    @Nullable
    public class_1321 recreateEntity(MinecraftServer server, class_5321<class_1937> worldKey, int x, int y, int z) {
        if (server == null || this.entityData == null) {
            return null;
        }
        String typeId = this.entityData.method_10558("id");
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(new class_2960(typeId));
        this.getEntity(server).thenAccept(pdh -> {
            if (pdh != null && pdh.entity() != null) {
                pdh.entity().method_31472();
            }
        });
        class_1297 entity = type.method_5883((class_1937)server.method_3847(worldKey));
        if (!(entity instanceof class_1321)) {
            return null;
        }
        class_1321 tame = (class_1321)entity;
        class_3222 player = server.method_3760().method_14602(this.ownerUuid);
        if (player != null) {
            class_2487 left = player.method_7356();
            class_2487 right = player.method_7308();
            if (!left.method_33133() && left.method_25928("UUID") && left.method_25926("UUID").equals(this.entityUuid)) {
                ((ShoulderAccessor)player).friendsforlife_clearShoulder(this.entityUuid);
            }
            if (!right.method_33133() && right.method_25928("UUID") && right.method_25926("UUID").equals(this.entityUuid)) {
                ((ShoulderAccessor)player).friendsforlife_clearShoulder(this.entityUuid);
            }
        }
        class_2487 nbtCopy = this.entityData.method_10553();
        UUID oldUuid = this.entityUuid;
        this.entityUuid = UUID.randomUUID();
        nbtCopy.method_25927("UUID", this.entityUuid);
        nbtCopy.method_10551("Pos");
        nbtCopy.method_10551("Motion");
        nbtCopy.method_10551("Rotation");
        nbtCopy.method_10551("Sitting");
        nbtCopy.method_10551("DeathTime");
        nbtCopy.method_10551("ActiveEffects");
        tame.method_5651(nbtCopy);
        this.entityData = nbtCopy;
        server.method_3847(worldKey).method_8649((class_1297)tame);
        tame.method_5808((double)x, (double)y, (double)z, entity.method_36454(), entity.method_36455());
        PetTracker pt = PetTracker.get(server);
        pt.getRecreatedMap().add(oldUuid);
        return tame;
    }

    private boolean entityDataMatchesShoulder(class_2487 shoulderNbt, class_2487 savedEntityData) {
        int savedVariant;
        int shoulderVariant;
        String savedId;
        String shoulderId = shoulderNbt.method_10558("id");
        if (!shoulderId.equals(savedId = savedEntityData.method_10558("id"))) {
            return false;
        }
        if (shoulderId.equals("minecraft:parrot") && (shoulderVariant = shoulderNbt.method_10550("Variant")) != (savedVariant = savedEntityData.method_10550("Variant"))) {
            return false;
        }
        boolean shoulderHasName = shoulderNbt.method_10545("CustomName");
        boolean savedHasName = savedEntityData.method_10545("CustomName");
        if (shoulderHasName && savedHasName) {
            String shoulderName = class_2561.class_2562.method_10877((String)shoulderNbt.method_10558("CustomName")).getString();
            String savedName = class_2561.class_2562.method_10877((String)savedEntityData.method_10558("CustomName")).getString();
            return shoulderName.equals(savedName);
        }
        return !shoulderHasName && !savedHasName;
    }

    public void onRemoved(MinecraftServer server) {
        OcarinaRegistry.get(server).unregisterAllForPet(this.uuid, server);
    }

    public record PetEntityHandle(@Nullable class_1321 entity, @Nullable class_2487 shoulderNbt) {
    }
}

