/*
 * Decompiled with CFR 0.152.
 */
package com.krookedlilly.autohidehud;

import com.google.gson.Gson;
import com.krookedlilly.autohidehud.AutoHideHUDConfig;
import com.krookedlilly.autohidehud.AutoHideHUDKeyBindings;
import com.krookedlilly.autohidehud.PlayerDataServer;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.slf4j.Logger;

@Mod(value="autohidehud", dist={Dist.CLIENT})
public class AutoHideHUD {
    public static final String MOD_ID = "autohidehud";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final PlayerData LAST_PLAYER_DATA = new PlayerData();
    private static final PlayerData TEMP_PLAYER_DATA = new PlayerData();
    private static PlayerDataServer dataServer;
    private static int currentTick;
    private static int lastUpdatedTick;
    private static long fadeStartTime;
    private static boolean hudState;
    private static boolean preventHide;
    private static float alpha;
    private static float currentAlpha;
    protected static int tickDuration;
    protected static int serverTickRate;
    public static boolean inMenu;
    public static float hotbarAlpha;
    public static boolean wasSleeping;

    public AutoHideHUD(IEventBus modBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AutoHideHUDConfig.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static void startServer() {
        if (!((Boolean)AutoHideHUDConfig.autoStartPlayerDataServer.get()).booleanValue()) {
            return;
        }
        if (dataServer != null && dataServer.isRunning()) {
            LOGGER.info("Server already running, skipping start");
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (minecraft.level == null || !minecraft.level.isClientSide()) {
            LOGGER.info("Level is NULL or not client side, skipping start");
            return;
        }
        if (player == null) {
            LOGGER.info("Local player is NULL, skipping start");
            return;
        }
        LOGGER.info("Starting player data server");
        dataServer = new PlayerDataServer();
        dataServer.start();
    }

    public static void stopServer() {
        if (dataServer == null || !dataServer.isRunning()) {
            LOGGER.info("Data server was NULL or not running. Nothing to stop");
            return;
        }
        if (dataServer != null) {
            dataServer.stop();
            dataServer = null;
            LOGGER.info("Player data server stopped");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!((Boolean)AutoHideHUDConfig.autoStartPlayerDataServer.get()).booleanValue()) {
            return;
        }
        if (event.getLevel().isClientSide() && event.getEntity() instanceof LocalPlayer) {
            LOGGER.info("Local player joined world, starting data server");
            AutoHideHUD.startServer();
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        if (((KeyMapping)AutoHideHUDKeyBindings.REVEAL_KEY.get()).consumeClick()) {
            preventHide = false;
            lastUpdatedTick = currentTick;
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            if (dataServer != null && dataServer.isRunning()) {
                LOGGER.info("Player disconnected, stopping data server");
                AutoHideHUD.stopServer();
            }
        } else {
            Inventory inventory = player.getInventory();
            AutoHideHUD.TEMP_PLAYER_DATA.health = player.getHealth();
            AutoHideHUD.TEMP_PLAYER_DATA.maxHealth = player.getMaxHealth();
            AutoHideHUD.TEMP_PLAYER_DATA.armor = player.getArmorValue();
            AutoHideHUD.TEMP_PLAYER_DATA.foodLevel = player.getFoodData().getFoodLevel();
            AutoHideHUD.TEMP_PLAYER_DATA.saturation = player.getFoodData().getSaturationLevel();
            AutoHideHUD.TEMP_PLAYER_DATA.airSupply = player.getAirSupply();
            AutoHideHUD.TEMP_PLAYER_DATA.isCreative = player.isCreative();
            AutoHideHUD.TEMP_PLAYER_DATA.experienceLevel = player.experienceLevel;
            AutoHideHUD.TEMP_PLAYER_DATA.experienceProgress = player.experienceProgress;
            AutoHideHUD.TEMP_PLAYER_DATA.selectedHotbarSlot = inventory.getSelectedSlot();
            AutoHideHUD.TEMP_PLAYER_DATA.vehicleHealth = 0.01f;
            AutoHideHUD.TEMP_PLAYER_DATA.maxVehicleHealth = 0.01f;
            AutoHideHUD.TEMP_PLAYER_DATA.inMenu = minecraft.screen != null && player.getBedOrientation() == null && (minecraft.screen.isInGameUi() || minecraft.screen.isPauseScreen());
            AutoHideHUD.TEMP_PLAYER_DATA.x = player.getX();
            AutoHideHUD.TEMP_PLAYER_DATA.y = player.getY();
            AutoHideHUD.TEMP_PLAYER_DATA.z = player.getZ();
            AutoHideHUD.TEMP_PLAYER_DATA.yaw = player.getYRot();
            AutoHideHUD.TEMP_PLAYER_DATA.pitch = player.getXRot();
            AutoHideHUD.TEMP_PLAYER_DATA.facing = player.getDirection().toString();
            AutoHideHUD.TEMP_PLAYER_DATA.showPosition = (Boolean)AutoHideHUDConfig.showPosition.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showFacing = (Boolean)AutoHideHUDConfig.showFacing.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showHealth = (Boolean)AutoHideHUDConfig.showHealth.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showHealthWarning = (Integer)AutoHideHUDConfig.showHealthWarning.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showArmorLevel = (Boolean)AutoHideHUDConfig.showArmorLevel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showFoodLevel = (Boolean)AutoHideHUDConfig.showFoodLevel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showSaturationLevel = (Boolean)AutoHideHUDConfig.showSaturationLevel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showAirLevel = (Boolean)AutoHideHUDConfig.showAirLevel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showVehicleHealth = (Boolean)AutoHideHUDConfig.showVehicleHealth.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showExperienceLevel = (Boolean)AutoHideHUDConfig.showExperienceLevel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showExperienceProgress = (Boolean)AutoHideHUDConfig.showExperienceProgress.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showStatusEffects = (Boolean)AutoHideHUDConfig.showStatusEffects.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showHotbarItems = (Boolean)AutoHideHUDConfig.showHotbarItems.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showHotbarItemsDurability = (Boolean)AutoHideHUDConfig.showHotbarItemsDurability.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showHotbarItemsDurabilityPercent = (Boolean)AutoHideHUDConfig.showHotbarItemsDurabilityPercent.get();
            AutoHideHUD.TEMP_PLAYER_DATA.showSelectedItemLabel = (Boolean)AutoHideHUDConfig.showSelectedItemLabel.get();
            AutoHideHUD.TEMP_PLAYER_DATA.focusedBackgroundColor = (String)AutoHideHUDConfig.focusedBackgroundColor.get();
            AutoHideHUD.TEMP_PLAYER_DATA.focusedBackgroundOpacity = (Integer)AutoHideHUDConfig.focusedBackgroundOpacity.get();
            AutoHideHUD.TEMP_PLAYER_DATA.notFocusedBackgroundColor = (String)AutoHideHUDConfig.notFocusedBackgroundColor.get();
            AutoHideHUD.TEMP_PLAYER_DATA.notFocusedBackgroundOpacity = (Integer)AutoHideHUDConfig.notFocusedBackgroundOpacity.get();
            AutoHideHUD.TEMP_PLAYER_DATA.portNumber = PlayerDataServer.PORT;
            inMenu = AutoHideHUD.TEMP_PLAYER_DATA.inMenu;
            if (!inMenu) {
                ++currentTick;
            }
            InventoryItemData selectedItem = null;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!stack.isEmpty()) {
                    InventoryItemData data = new InventoryItemData();
                    ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                    data.slot = i;
                    data.id = itemId.toString();
                    data.name = stack.getHoverName().getString();
                    data.count = stack.getCount();
                    data.damage = stack.getDamageValue();
                    data.maxDamage = stack.getMaxDamage();
                    data.durability = data.maxDamage - data.damage;
                    data.enchanted = stack.isEnchanted();
                    boolean bl = data.selected = i == AutoHideHUD.TEMP_PLAYER_DATA.selectedHotbarSlot;
                    if (data.selected) {
                        selectedItem = data;
                    }
                    AutoHideHUD.TEMP_PLAYER_DATA.inventoryData[i] = data;
                    continue;
                }
                AutoHideHUD.TEMP_PLAYER_DATA.inventoryData[i] = null;
            }
            ItemStack stack = player.getOffhandItem();
            if (!stack.isEmpty()) {
                InventoryItemData data = new InventoryItemData();
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                data.slot = 9;
                data.id = itemId.toString();
                data.name = stack.getHoverName().getString();
                data.count = stack.getCount();
                data.damage = stack.getDamageValue();
                data.maxDamage = stack.getMaxDamage();
                data.durability = data.maxDamage - data.damage;
                data.enchanted = stack.isEnchanted();
                AutoHideHUD.TEMP_PLAYER_DATA.inventoryData[9] = data;
            } else {
                AutoHideHUD.TEMP_PLAYER_DATA.inventoryData[9] = null;
            }
            AutoHideHUD.TEMP_PLAYER_DATA.statusEffects.clear();
            player.getActiveEffects().forEach(effect -> {
                StatusEffectData data = new StatusEffectData();
                data.name = effect.getEffect().getRegisteredName();
                data.amplifier = effect.getAmplifier();
                data.duration = effect.getDuration();
                AutoHideHUD.TEMP_PLAYER_DATA.statusEffects.add(data);
            });
            Entity entity = player.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity;
                AutoHideHUD.TEMP_PLAYER_DATA.vehicleHealth = vehicle.getHealth();
                AutoHideHUD.TEMP_PLAYER_DATA.maxVehicleHealth = vehicle.getMaxHealth();
            }
            if (AutoHideHUD.TEMP_PLAYER_DATA.inMenu != AutoHideHUD.LAST_PLAYER_DATA.inMenu) {
                AutoHideHUD.LAST_PLAYER_DATA.inMenu = AutoHideHUD.TEMP_PLAYER_DATA.inMenu;
                if (AutoHideHUD.TEMP_PLAYER_DATA.inMenu && ((Boolean)AutoHideHUDConfig.returnToStateFromMenu.get()).booleanValue()) {
                    if (!hudState) {
                        preventHide = true;
                        hotbarAlpha = 1.0f;
                    } else {
                        preventHide = false;
                        lastUpdatedTick = currentTick;
                    }
                } else if (AutoHideHUD.TEMP_PLAYER_DATA.inMenu) {
                    preventHide = false;
                    lastUpdatedTick = currentTick;
                    hotbarAlpha = 1.0f;
                } else if (((Boolean)AutoHideHUDConfig.returnToStateFromMenu.get()).booleanValue()) {
                    preventHide = false;
                } else {
                    preventHide = false;
                    lastUpdatedTick = currentTick;
                }
            }
            if (AutoHideHUD.TEMP_PLAYER_DATA.isCreative && (Boolean)AutoHideHUDConfig.revealIfInCreative.get() != false || (float)((Integer)AutoHideHUDConfig.revealWhenPlayerHealthChangedBelow.get()).intValue() / 100.0f > AutoHideHUD.TEMP_PLAYER_DATA.health / AutoHideHUD.TEMP_PLAYER_DATA.maxHealth || (float)((Integer)AutoHideHUDConfig.revealWhenVehicleHealthChangedBelow.get()).intValue() / 100.0f > AutoHideHUD.TEMP_PLAYER_DATA.vehicleHealth / AutoHideHUD.TEMP_PLAYER_DATA.maxVehicleHealth || (float)((Integer)AutoHideHUDConfig.revealWhenPlayerFoodChangedBelow.get()).intValue() / 100.0f > (float)AutoHideHUD.TEMP_PLAYER_DATA.foodLevel / (float)AutoHideHUD.TEMP_PLAYER_DATA.maxFoodLevel || (float)((Integer)AutoHideHUDConfig.revealWhenPlayerAirChangedBelow.get()).intValue() / 100.0f > (float)AutoHideHUD.TEMP_PLAYER_DATA.airSupply / (float)AutoHideHUD.TEMP_PLAYER_DATA.maxAirSupply || selectedItem != null && selectedItem.maxDamage != 0 && (float)((Integer)AutoHideHUDConfig.revealOnSelectedHotbarDurabilityChange.get()).intValue() / 100.0f > (float)selectedItem.durability / (float)selectedItem.maxDamage || AutoHideHUD.TEMP_PLAYER_DATA.armor != AutoHideHUD.LAST_PLAYER_DATA.armor && (Boolean)AutoHideHUDConfig.revealOnPlayerArmorChange.get() != false || AutoHideHUD.TEMP_PLAYER_DATA.experienceLevel != AutoHideHUD.LAST_PLAYER_DATA.experienceLevel && AutoHideHUD.TEMP_PLAYER_DATA.experienceLevel % (Integer)AutoHideHUDConfig.revealOnPlayerExperienceLevelChange.get() == 0 || AutoHideHUD.TEMP_PLAYER_DATA.experienceProgress != AutoHideHUD.LAST_PLAYER_DATA.experienceProgress && (Boolean)AutoHideHUDConfig.revealOnPlayerExperienceProgressChange.get() != false || AutoHideHUD.TEMP_PLAYER_DATA.selectedHotbarSlot != AutoHideHUD.LAST_PLAYER_DATA.selectedHotbarSlot && ((Boolean)AutoHideHUDConfig.revealOnPlayerHotbarSlotChange.get()).booleanValue()) {
                lastUpdatedTick = currentTick;
                AutoHideHUD.LAST_PLAYER_DATA.health = AutoHideHUD.TEMP_PLAYER_DATA.health;
                AutoHideHUD.LAST_PLAYER_DATA.maxHealth = AutoHideHUD.TEMP_PLAYER_DATA.maxHealth;
                AutoHideHUD.LAST_PLAYER_DATA.armor = AutoHideHUD.TEMP_PLAYER_DATA.armor;
                AutoHideHUD.LAST_PLAYER_DATA.foodLevel = AutoHideHUD.TEMP_PLAYER_DATA.foodLevel;
                AutoHideHUD.LAST_PLAYER_DATA.airSupply = AutoHideHUD.TEMP_PLAYER_DATA.airSupply;
                AutoHideHUD.LAST_PLAYER_DATA.isCreative = AutoHideHUD.TEMP_PLAYER_DATA.isCreative;
                AutoHideHUD.LAST_PLAYER_DATA.experienceLevel = AutoHideHUD.TEMP_PLAYER_DATA.experienceLevel;
                AutoHideHUD.LAST_PLAYER_DATA.experienceProgress = AutoHideHUD.TEMP_PLAYER_DATA.experienceProgress;
                AutoHideHUD.LAST_PLAYER_DATA.selectedHotbarSlot = AutoHideHUD.TEMP_PLAYER_DATA.selectedHotbarSlot;
                AutoHideHUD.LAST_PLAYER_DATA.vehicleHealth = AutoHideHUD.TEMP_PLAYER_DATA.vehicleHealth;
            }
            if (currentTick % serverTickRate == 0 && dataServer != null) {
                dataServer.broadcastPlayerData(GSON.toJson((Object)TEMP_PLAYER_DATA));
            }
        }
    }

    @SubscribeEvent
    public void onRenderHUDPre(RenderGuiLayerEvent.Pre event) {
        if (!((Boolean)AutoHideHUDConfig.enableAutoHiding.get()).booleanValue()) {
            return;
        }
        if (!preventHide && currentTick - lastUpdatedTick > tickDuration) {
            float targetAlpha = (float)AutoHideHUDConfig.targetOpacity.getAsDouble();
            hudState = false;
            if (this.shouldHideLayer(event.getName())) {
                if (currentAlpha <= targetAlpha) {
                    alpha = currentAlpha;
                    if (((Boolean)AutoHideHUDConfig.hideHotbar.get()).booleanValue() && event.getName().equals((Object)VanillaGuiLayers.HOTBAR)) {
                        hotbarAlpha = alpha;
                    }
                    return;
                }
                float fadeDuration = (float)AutoHideHUDConfig.fadeOutSpeed.getAsDouble();
                if (fadeDuration == 0.0f) {
                    alpha = currentAlpha = targetAlpha;
                    if (((Boolean)AutoHideHUDConfig.hideHotbar.get()).booleanValue() && event.getName().equals((Object)VanillaGuiLayers.HOTBAR)) {
                        hotbarAlpha = alpha;
                    }
                    fadeStartTime = -1L;
                    return;
                }
                if (fadeStartTime == -1L) {
                    fadeStartTime = System.currentTimeMillis();
                }
                if ((currentAlpha = this.lerpAlpha((long)(fadeDuration * 1000.0f), targetAlpha)) <= targetAlpha) {
                    currentAlpha = targetAlpha;
                    fadeStartTime = -1L;
                }
                alpha = currentAlpha;
                if (((Boolean)AutoHideHUDConfig.hideHotbar.get()).booleanValue() && event.getName().equals((Object)VanillaGuiLayers.HOTBAR)) {
                    hotbarAlpha = alpha;
                }
            } else {
                alpha = 1.0f;
            }
        } else if (!preventHide) {
            hudState = true;
            currentAlpha = 1.0f;
            hotbarAlpha = 1.0f;
            alpha = 1.0f;
            fadeStartTime = -1L;
        }
    }

    private boolean shouldHideLayer(ResourceLocation layerName) {
        if (((Boolean)AutoHideHUDConfig.hideHotbar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.HOTBAR)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideSelectedItemName.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.SELECTED_ITEM_NAME)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideHealthBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideHealthBar.get()).booleanValue() && layerName.toString().equals("appleskin:health_offset")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideHealthBar.get()).booleanValue() && layerName.toString().equals("appleskin:health_restored")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideArmorLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.ARMOR_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.FOOD_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.toString().equals("appleskin:hunger_restored")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.toString().equals("appleskin:food_offset")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.toString().equals("appleskin:saturation_level")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideFoodLevel.get()).booleanValue() && layerName.toString().equals("appleskin:exhaustion_level")) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideVehicleHealth.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.VEHICLE_HEALTH)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideAirLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideExperienceLevel.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.EXPERIENCE_LEVEL)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideContextualInfoBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CONTEXTUAL_INFO_BAR)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideContextualInfoBar.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CONTEXTUAL_INFO_BAR_BACKGROUND)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideCrossHair.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideStatusEffects.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.EFFECTS)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideChatMessages.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.CHAT)) {
            return true;
        }
        if (((Boolean)AutoHideHUDConfig.hideSleepOverlay.get()).booleanValue() && layerName.equals((Object)VanillaGuiLayers.SUBTITLE_OVERLAY)) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (minecraft.screen != null && player != null && minecraft.screen.getTitle().getString().equals("Chat screen") && player.getBedOrientation() != null) {
                wasSleeping = true;
                return true;
            }
            if (wasSleeping) {
                wasSleeping = false;
                return true;
            }
            return false;
        }
        return ((List)AutoHideHUDConfig.additionalLayerIds.get()).contains(layerName.toString());
    }

    public float lerpAlpha(long duration, float endAlpha) {
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - fadeStartTime;
        float t = Math.min(1.0f, (float)elapsed / (float)duration);
        return 1.0f + (endAlpha - 1.0f) * t;
    }

    public static int applyAlpha(int color) {
        return AutoHideHUD.applyAlpha(color, false);
    }

    public static int applyAlpha(int color, boolean isText) {
        if (alpha >= 1.0f || inMenu) {
            return color;
        }
        int alpha = color >> 24 & 0xFF;
        int rgb = color & 0xFFFFFF;
        int newAlpha = (int)((float)alpha * (AutoHideHUD.alpha + (isText && (float)alpha != 0.0f ? 0.005f : 0.0f)));
        return newAlpha << 24 | rgb;
    }

    static {
        currentTick = 0;
        lastUpdatedTick = 0;
        fadeStartTime = -1L;
        hudState = true;
        preventHide = false;
        alpha = 1.0f;
        currentAlpha = 1.0f;
        tickDuration = 100;
        serverTickRate = 5;
        inMenu = false;
        hotbarAlpha = 1.0f;
        wasSleeping = false;
    }

    static class PlayerData {
        float health = 20.0f;
        float maxHealth = 20.0f;
        int armor = 0;
        int foodLevel = 20;
        int maxFoodLevel = 20;
        float saturation = 20.0f;
        boolean isCreative = false;
        int experienceLevel = 0;
        float experienceProgress = 0.0f;
        int selectedHotbarSlot = 0;
        int airSupply = 300;
        int maxAirSupply = 300;
        float vehicleHealth = 0.01f;
        float maxVehicleHealth = 0.01f;
        boolean inMenu = false;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yaw = 0.0f;
        float pitch = 0.0f;
        String facing = "";
        InventoryItemData[] inventoryData = new InventoryItemData[10];
        ArrayList<StatusEffectData> statusEffects = new ArrayList();
        int portNumber = 33333;
        boolean showPosition = true;
        boolean showFacing = true;
        boolean showHealth = true;
        int showHealthWarning = 30;
        boolean showArmorLevel = true;
        boolean showFoodLevel = true;
        boolean showSaturationLevel = true;
        boolean showVehicleHealth = true;
        boolean showAirLevel = true;
        boolean showExperienceLevel = true;
        boolean showExperienceProgress = true;
        boolean showStatusEffects = true;
        boolean showHotbarItems = true;
        boolean showHotbarItemsDurability = true;
        boolean showHotbarItemsDurabilityPercent = true;
        boolean showSelectedItemLabel = false;
        String focusedBackgroundColor = "#000000";
        int focusedBackgroundOpacity = 255;
        String notFocusedBackgroundColor = "#000000";
        int notFocusedBackgroundOpacity = 0;

        PlayerData() {
        }
    }

    static class InventoryItemData {
        String name = "";
        String id = "";
        int count = 0;
        int slot = 0;
        int damage = 0;
        int maxDamage = 0;
        int durability = 0;
        boolean enchanted = false;
        boolean selected = false;

        InventoryItemData() {
        }
    }

    static class StatusEffectData {
        String name = "";
        int amplifier = 0;
        int duration = 0;

        StatusEffectData() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StatusEffectData other = (StatusEffectData)obj;
            return this.amplifier == other.amplifier && this.duration == other.duration && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.amplifier;
            result = 31 * result + this.duration;
            return result;
        }
    }
}

