/*
 * Decompiled with CFR 0.152.
 */
package com.krookedlilly.autohidehud;

import com.krookedlilly.autohidehud.AutoHideHUD;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;

public class PlayerDataServer {
    public static int PORT = 25922;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private volatile boolean running = false;
    private final List<ClientHandler> clients = new CopyOnWriteArrayList<ClientHandler>();
    private final Queue<String> dataQueue = new ConcurrentLinkedQueue<String>();

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.serverThread = new Thread(this::run, "PlayerDataServer");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    private void run() {
        try {
            this.serverSocket = new ServerSocket(PORT);
            AutoHideHUD.LOGGER.info("Player data server started on port " + PORT);
            while (this.running) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    AutoHideHUD.LOGGER.info("Client connected: " + String.valueOf(clientSocket.getInetAddress()));
                    ClientHandler handler = new ClientHandler(clientSocket);
                    this.clients.add(handler);
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closeServer();
        }
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.closeServer();
        Thread cleanupThread = new Thread(() -> {
            for (ClientHandler client : this.clients) {
                client.close();
            }
            this.clients.clear();
            if (this.serverThread != null) {
                try {
                    this.serverThread.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            AutoHideHUD.LOGGER.info("Player data server cleanup complete");
        }, "PlayerDataServer-Cleanup");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
    }

    private void closeServer() {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void broadcastPlayerData(String jsonData) {
        this.dataQueue.offer(jsonData);
        this.sendQueuedData();
    }

    private void sendQueuedData() {
        String data;
        while ((data = this.dataQueue.poll()) != null) {
            for (ClientHandler client : this.clients) {
                client.send(data);
            }
        }
    }

    private class ClientHandler {
        private final Socket socket;
        private PrintWriter out;
        private volatile boolean connected = true;

        public ClientHandler(Socket socket) {
            this.socket = socket;
            try {
                this.out = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.connected = false;
            }
        }

        public void send(String data) {
            if (this.connected && this.out != null) {
                try {
                    this.out.println(data);
                    if (this.out.checkError()) {
                        this.close();
                    }
                }
                catch (Exception e) {
                    this.close();
                }
            }
        }

        public void close() {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            PlayerDataServer.this.clients.remove(this);
            try {
                if (this.out != null) {
                    this.out.close();
                }
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
                AutoHideHUD.LOGGER.info("Client disconnected");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

