/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import net.mcreator.animarmor.ClientEvents;
import net.mcreator.animarmor.KitArmorItem;
import net.mcreator.animarmor.item.LeatherKitArmorItem;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FoxArmorLayerRenderer<T extends Fox>
extends RenderLayer<T, FoxModel<T>> {
    private final FoxModel<T> model;

    public FoxArmorLayerRenderer(RenderLayerParent<T, FoxModel<T>> parent, EntityModelSet models) {
        super(parent);
        this.model = new FoxModel(models.m_171103_(ClientEvents.FOX_ARMOR_LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T fox, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Item item;
        ItemStack stack = fox.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof KitArmorItem)) {
            return;
        }
        KitArmorItem armorItem = (KitArmorItem)item;
        ((FoxModel)this.m_117386_()).m_102624_(this.model);
        this.model.m_6839_(fox, limbSwing, limbSwingAmount, partialTicks);
        this.model.m_6973_(fox, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ResourceLocation armorTexture = armorItem.getTexture();
        VertexConsumer vertexConsumer = stack.m_41790_() ? VertexMultiConsumer.m_86168_((VertexConsumer)buffer.m_6299_(RenderType.m_110496_()), (VertexConsumer)buffer.m_6299_(RenderType.m_110458_((ResourceLocation)armorTexture))) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)armorTexture));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        Item item2 = stack.m_41720_();
        if (item2 instanceof LeatherKitArmorItem) {
            LeatherKitArmorItem leatherArmor = (LeatherKitArmorItem)item2;
            int color = leatherArmor.m_41121_(stack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            ResourceLocation overlay = new ResourceLocation("animarmor:textures/entities/leather_fox_armor_overlay.png");
            VertexConsumer overlayConsumer = stack.m_41790_() ? VertexMultiConsumer.m_86168_((VertexConsumer)buffer.m_6299_(RenderType.m_110496_()), (VertexConsumer)buffer.m_6299_(RenderType.m_110458_((ResourceLocation)overlay))) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)overlay));
            this.model.m_7695_(poseStack, overlayConsumer, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }
}

