/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.animarmor.AnimarmorModRecipeSerializers;
import net.mcreator.animarmor.init.AnimarmorModItems;
import net.mcreator.animarmor.item.HogdyeItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class HogDyeRecipe
extends CustomRecipe {
    public HogDyeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        boolean foundNetherWart = false;
        ArrayList dyes = Lists.newArrayList();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42588_)) {
                if (foundNetherWart) {
                    return false;
                }
                foundNetherWart = true;
                continue;
            }
            if (stack.m_41720_() instanceof DyeItem) {
                dyes.add(stack);
                continue;
            }
            return false;
        }
        return foundNetherWart && !dyes.isEmpty();
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ArrayList dyes = Lists.newArrayList();
        boolean foundWart = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42588_)) {
                if (foundWart) {
                    return ItemStack.f_41583_;
                }
                foundWart = true;
                continue;
            }
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                dyes.add(dye);
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (!foundWart || dyes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)AnimarmorModItems.HOGDYE.get());
        int color = HogDyeRecipe.mixColors(dyes);
        ((HogdyeItem)result.m_41720_()).m_41115_(result, color);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AnimarmorModRecipeSerializers.HOG_DYE.get();
    }

    private static int mixColors(List<DyeItem> dyes) {
        int[] rgb = new int[3];
        int total = 0;
        float scale = 0.0f;
        for (DyeItem dye : dyes) {
            float[] comps = dye.m_41089_().m_41068_();
            rgb[0] = rgb[0] + (int)(comps[0] * 255.0f);
            rgb[1] = rgb[1] + (int)(comps[1] * 255.0f);
            rgb[2] = rgb[2] + (int)(comps[2] * 255.0f);
            scale += Math.max(comps[0], Math.max(comps[1], comps[2]));
            ++total;
        }
        if (total == 0) {
            return 0xFFFFFF;
        }
        int r = rgb[0] / total;
        int g = rgb[1] / total;
        int b = rgb[2] / total;
        return r << 16 | g << 8 | b;
    }
}

