/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ArmorItem;

public class VillagerHumanoidModel<T extends AbstractVillager>
extends HumanoidModel<T>
implements VillagerHeadModel {
    private final ModelPart nose;
    private final ModelPart jacket;
    private final ModelPart hat;
    private final ModelPart hatRim;
    public final ModelPart arms;

    public VillagerHumanoidModel(ModelPart root) {
        super(root);
        this.hat = this.f_102808_.m_171324_("hat");
        this.hatRim = this.hat.m_171324_("hat_rim");
        this.nose = this.f_102808_.m_171324_("nose");
        this.jacket = this.f_102810_.m_171324_("jacket");
        this.arms = root.m_171324_("arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.f_171404_);
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        hat.m_171599_("hat_rim", CubeListBuilder.m_171558_().m_171514_(30, 47).m_171481_(-8.0f, -8.0f, -6.0f, 16.0f, 16.0f, 1.0f), PartPose.m_171430_((float)-1.5707964f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f), PartPose.f_171404_);
        body.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable)super.m_5608_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.jacket));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean unhappy = entity.m_35303_() > 0;
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (unhappy) {
            this.f_102808_.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
            this.f_102808_.f_104203_ = 0.4f;
        } else {
            this.f_102808_.f_104205_ = 0.0f;
        }
        this.f_102812_.f_104201_ = 3.0f;
        this.f_102812_.f_104202_ = -1.0f;
        this.f_102812_.f_104203_ = -0.75f;
        this.f_102811_.f_104201_ = 3.0f;
        this.f_102811_.f_104202_ = -1.0f;
        this.f_102811_.f_104203_ = -0.75f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        boolean chestArmor = entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem;
        boolean headArmor = entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorItem;
        this.jacket.f_104207_ = !chestArmor;
        this.hat.f_104207_ = !headArmor;
        this.hatRim.f_104207_ = !headArmor;
        this.arms.f_104207_ = true;
        this.f_102812_.f_104207_ = false;
        this.f_102811_.f_104207_ = false;
    }

    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    public void m_7491_(boolean visible) {
        this.hat.f_104207_ = visible;
        this.hatRim.f_104207_ = visible;
    }
}

