/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.animarmor.OwnableBlaze;
import net.mcreator.animarmor.OwnableHoglin;
import net.mcreator.animarmor.item.BlazeArmorItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Blaze.class})
public abstract class BlazeTamingMixin
extends Monster
implements OwnableBlaze {
    @Unique
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BlazeTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(BlazeTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Unique
    protected SimpleContainer inventory;
    @Unique
    private static final int INV_SLOT_ARMOR = 0;
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("07b5e37c-3f7f-4e08-915f-5c88d5f9a77e");

    protected BlazeTamingMixin(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void animarmor$addOwnerHurtTargetGoal(CallbackInfo ci) {
        Blaze self = (Blaze)this;
        this.f_21346_.m_25352_(3, (Goal)new BlazeHurtTargetGoal(this));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void animarmor$defineTamableData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag tag) {
        ItemStack armor;
        super.m_7380_(tag);
        if (this.getOwnerUUID() != null) {
            tag.m_128362_("Owner", this.getOwnerUUID());
        }
        if (!(armor = this.inventory.m_8020_(0)).m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)armor.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
            this.setTame(true);
        }
        if (tag.m_128425_("ArmorItem", 10)) {
            ItemStack armor = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"));
            this.inventory.m_6836_(0, armor);
            this.setArmorEquipment(armor);
        }
    }

    @Override
    @Unique
    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    @Unique
    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity != null && entity.m_20148_().equals(this.getOwnerUUID());
    }

    @Override
    @Unique
    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    @Override
    @Unique
    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    @Unique
    public void setTame(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public boolean m_7307_(Entity other) {
        if (this.isTame()) {
            LivingEntity owner = this.getOwner();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                return owner.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public Team m_5647_() {
        LivingEntity owner;
        if (this.isTame() && (owner = this.getOwner()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_6779_(LivingEntity entity) {
        return this.isOwnedBy(entity) ? false : super.m_6779_(entity);
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamable;
        OwnableHoglin ownable;
        Hoglin otherHoglin;
        if (target == owner) {
            return false;
        }
        if (target instanceof Hoglin && (otherHoglin = (Hoglin)target) instanceof OwnableHoglin && (ownable = (OwnableHoglin)otherHoglin).isTame()) {
            if (this.getOwner() != null && this.getOwner().equals((Object)ownable.getOwner())) {
                return false;
            }
            return false;
        }
        if (owner instanceof Player) {
            Player targetPlayer;
            Player player = (Player)owner;
            if (target instanceof Player && !player.m_7099_(targetPlayer = (Player)target)) {
                return false;
            }
        }
        return !(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).m_21824_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Blaze self = (Blaze)this;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ItemStack currentArmor = this.inventory.m_8020_(0);
        if (this.isTame() && player.m_6144_() && !currentArmor.m_41619_()) {
            self.m_19983_(currentArmor);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
            self.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (this.isTame() && item instanceof BlazeArmorItem) {
            BlazeArmorItem armorItem = (BlazeArmorItem)item;
            if (!currentArmor.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentArmor)) {
                return InteractionResult.PASS;
            }
            ItemStack newArmor = stack.m_255036_(1);
            if (!currentArmor.m_41619_()) {
                self.m_19983_(currentArmor);
            }
            this.inventory.m_6836_(0, newArmor);
            this.setArmorEquipment(newArmor);
            self.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void animarmor$createBlazeInventory(EntityType<? extends Blaze> type, Level level, CallbackInfo ci) {
        this.createInventory();
    }

    @Unique
    private void createInventory() {
        SimpleContainer old = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (old != null) {
            old.m_19181_(this::containerChanged);
            ItemStack prev = old.m_8020_(0);
            if (!prev.m_41619_()) {
                this.inventory.m_6836_(0, prev.m_41777_());
            }
        }
        this.inventory.m_19164_(this::containerChanged);
        this.updateContainerEquipment();
    }

    @Unique
    private void containerChanged(Container container) {
        this.updateContainerEquipment();
    }

    @Unique
    private void updateContainerEquipment() {
        Blaze self = (Blaze)this;
        if (!self.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(0));
        }
    }

    @Unique
    protected void setArmorEquipment(ItemStack armor) {
        int protection;
        Blaze self = (Blaze)this;
        self.m_8061_(EquipmentSlot.CHEST, armor);
        self.m_21409_(EquipmentSlot.CHEST, 0.0f);
        AttributeInstance attr = self.m_21051_(Attributes.f_22284_);
        if (attr == null) {
            return;
        }
        attr.m_22120_(ARMOR_MODIFIER_UUID);
        if (this.isArmor(armor) && (protection = ((BlazeArmorItem)armor.m_41720_()).getProtection()) > 0) {
            attr.m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Blaze armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
        if (!armor.m_41619_()) {
            this.m_19983_(armor.m_41777_());
            this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
        }
    }

    @Unique
    public boolean canWearArmor() {
        return true;
    }

    @Unique
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof BlazeArmorItem;
    }

    @Unique
    public boolean isWearingArmor() {
        return !this.inventory.m_8020_(0).m_41619_();
    }

    public class BlazeHurtTargetGoal
    extends TargetGoal {
        private final OwnableBlaze tameBlaze;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public BlazeHurtTargetGoal(OwnableBlaze blaze) {
            super((Mob)blaze, false);
            this.tameBlaze = blaze;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.tameBlaze.isTame()) {
                LivingEntity owner = this.tameBlaze.getOwner();
                if (owner == null) {
                    return false;
                }
                this.ownerLastHurt = owner.m_21214_();
                int last = owner.m_21215_();
                return last != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_) && this.tameBlaze.wantsToAttack(this.ownerLastHurt, owner);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurt);
            LivingEntity owner = this.tameBlaze.getOwner();
            if (owner != null) {
                this.timestamp = owner.m_21215_();
            }
            super.m_8056_();
        }
    }
}

