/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import com.google.common.collect.ImmutableList;
import java.util.UUID;
import net.mcreator.animarmor.OwnableHoglin;
import net.mcreator.animarmor.ShootFireballBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.hoglin.HoglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HoglinAi.class})
public abstract class HoglinAIMixin {
    @Inject(method={"updateActivity"}, at={@At(value="HEAD")})
    private static void animarmor$preventMovementWhenSitting(Hoglin hoglin, CallbackInfo ci) {
        OwnableHoglin ownable;
        if (hoglin instanceof OwnableHoglin && (ownable = (OwnableHoglin)hoglin).isTame() && ownable.isOrderedToSit()) {
            hoglin.m_21573_().m_26573_();
            hoglin.m_7910_(0.0f);
            Brain brain = hoglin.m_6274_();
            brain.m_21936_(MemoryModuleType.f_26370_);
            brain.m_21936_(MemoryModuleType.f_26372_);
        }
    }

    @Inject(method={"updateActivity"}, at={@At(value="TAIL")})
    private static void animarmor$addTamedBehavior(Hoglin hoglin, CallbackInfo ci) {
        if (hoglin instanceof OwnableHoglin) {
            OwnableHoglin ownable = (OwnableHoglin)hoglin;
            try {
                if (!ownable.isTame() || ownable.isOrderedToSit()) {
                    return;
                }
                UUID ownerUUID = ownable.getOwnerUUID();
                if (ownerUUID == null) {
                    return;
                }
                Player ownerEntity = null;
                Level level = hoglin.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Entity e = serverLevel.m_8791_(ownerUUID);
                    if (e instanceof LivingEntity) {
                        ownerEntity = (LivingEntity)e;
                    }
                } else {
                    Player p = hoglin.m_9236_().m_46003_(ownerUUID);
                    if (p instanceof LivingEntity) {
                        ownerEntity = p;
                    }
                }
                if (ownerEntity == null) {
                    return;
                }
                LivingEntity ownerTarget = ownerEntity.m_21214_();
                LivingEntity ownerAttacker = ownerEntity.m_21188_();
                if (ownerTarget != null && ownerTarget.m_6084_() && ownerTarget != hoglin && ownable.wantsToAttack(ownerTarget, (LivingEntity)ownerEntity)) {
                    hoglin.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)ownerTarget);
                } else if (ownerAttacker != null && ownerAttacker.m_6084_() && ownerAttacker != hoglin && ownable.wantsToAttack(ownerAttacker, (LivingEntity)ownerEntity)) {
                    hoglin.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)ownerAttacker);
                }
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
    }

    @Inject(method={"initFightActivity"}, at={@At(value="TAIL")})
    private static void animarmor$addFireballAttack(Brain<Hoglin> brain, CallbackInfo ci) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of(ShootFireballBehavior.create(), (Object)BehaviorBuilder.m_257845_(Hoglin::m_34552_, (OneShot)MeleeAttack.m_257733_((int)40)), (Object)BehaviorBuilder.m_257845_(AgeableMob::m_6162_, (OneShot)MeleeAttack.m_257733_((int)15)), (Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)EraseMemoryIf.m_258093_(h -> h.m_6274_().m_21874_(MemoryModuleType.f_26375_), (MemoryModuleType)MemoryModuleType.f_26372_)), MemoryModuleType.f_26372_);
    }
}

