/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.animarmor.BannerAttachment;
import net.mcreator.animarmor.HogArmorItem;
import net.mcreator.animarmor.OwnableHoglin;
import net.mcreator.animarmor.init.AnimarmorModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Hoglin.class})
public abstract class HoglinArmorMixin
extends Animal
implements OwnableHoglin,
BannerAttachment {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(HoglinArmorMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private SimpleContainer inventory;
    @Unique
    private static final int SLOT_SADDLE = 0;
    @Unique
    private static final int SLOT_ARMOR = 1;
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("07b5e37c-3f7f-4e08-915f-5c88d5f9a77e");
    @Unique
    private static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("b09bb67f-6d5e-4e4c-b86d-1ad45265caae");
    @Unique
    private static final double NETHERITE_KB_RESIST = 0.2;
    @Unique
    private static final UUID BULLY_DAMAGE_MODIFIER_UUID = UUID.fromString("d6423c34-23f3-4e92-b0d3-9a92f11d2a21");
    @Unique
    private static final UUID BULLY_ARMOR_MODIFIER_UUID = UUID.fromString("6b62c9e9-d38e-4e0b-a77d-b86e7656c556");
    @Unique
    private static final UUID BULLY_KNOCKBACK_MODIFIER_UUID = UUID.fromString("c0b7c917-8a40-4563-86a9-6e1bfe9f5b45");
    @Unique
    private static final EntityDataAccessor<ItemStack> DATA_BANNER_STACK = SynchedEntityData.m_135353_(Hoglin.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private static final EntityDataAccessor<ItemStack> DATA_SKULL_STACK = SynchedEntityData.m_135353_(Hoglin.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_LAVA_LAUNCHER = SynchedEntityData.m_135353_(Hoglin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected HoglinArmorMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void animarmor$createHoglinInventory(EntityType<? extends Hoglin> type, Level level, CallbackInfo ci) {
        this.createInventory();
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineBannerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
        this.f_19804_.m_135372_(DATA_BANNER_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_SKULL_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_LAVA_LAUNCHER, (Object)false);
    }

    @Unique
    protected void createInventory() {
        SimpleContainer old = this.inventory;
        this.inventory = new SimpleContainer(2);
        if (old != null) {
            old.m_19181_(this::containerChanged);
            for (int i = 0; i < Math.min(old.m_6643_(), 2); ++i) {
                ItemStack copy = old.m_8020_(i);
                if (copy.m_41619_()) continue;
                this.inventory.m_6836_(i, copy.m_41777_());
            }
        }
        this.inventory.m_19164_(this::containerChanged);
        this.updateContainerEquipment();
    }

    @Unique
    protected void containerChanged(Container container) {
        this.updateContainerEquipment();
    }

    @Unique
    protected void updateContainerEquipment() {
        Hoglin self = (Hoglin)this;
        if (!self.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(1));
            this.setSaddleEquipment(this.inventory.m_8020_(0));
        }
    }

    @Unique
    protected void setSaddleEquipment(ItemStack saddle) {
        Hoglin self = (Hoglin)this;
        self.m_8061_(EquipmentSlot.MAINHAND, saddle);
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)(!saddle.m_41619_() ? 1 : 0));
    }

    @Unique
    protected void setArmorEquipment(ItemStack armor) {
        AttributeInstance kbAttr;
        Hoglin self = (Hoglin)this;
        self.m_8061_(EquipmentSlot.CHEST, armor);
        self.m_21409_(EquipmentSlot.CHEST, 0.0f);
        AttributeInstance armorAttr = self.m_21051_(Attributes.f_22284_);
        if (armorAttr != null) {
            int protection;
            armorAttr.m_22120_(ARMOR_MODIFIER_UUID);
            if (this.isArmor(armor) && (protection = ((HogArmorItem)armor.m_41720_()).getProtection()) > 0) {
                armorAttr.m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Hoglin armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
        if ((kbAttr = self.m_21051_(Attributes.f_22278_)) != null) {
            kbAttr.m_22120_(KNOCKBACK_MODIFIER_UUID);
            if (!armor.m_41619_() && armor.m_41720_().toString().toLowerCase().contains("netherite")) {
                kbAttr.m_22125_(new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "Netherite knockback resistance", 0.2, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Unique
    private void updateBullySkullEffects() {
        Hoglin self = (Hoglin)this;
        ItemStack skull = this.getSkullItem();
        AttributeInstance damageAttr = self.m_21051_(Attributes.f_22281_);
        AttributeInstance armorAttr = self.m_21051_(Attributes.f_22284_);
        AttributeInstance knockbackAttr = self.m_21051_(Attributes.f_22282_);
        if (damageAttr != null) {
            damageAttr.m_22120_(BULLY_DAMAGE_MODIFIER_UUID);
        }
        if (armorAttr != null) {
            armorAttr.m_22120_(BULLY_ARMOR_MODIFIER_UUID);
        }
        if (knockbackAttr != null) {
            knockbackAttr.m_22120_(BULLY_KNOCKBACK_MODIFIER_UUID);
        }
        if (this.isBullySkull(skull)) {
            if (damageAttr != null) {
                damageAttr.m_22125_(new AttributeModifier(BULLY_DAMAGE_MODIFIER_UUID, "Bully skull damage", 4.0, AttributeModifier.Operation.ADDITION));
            }
            if (armorAttr != null) {
                armorAttr.m_22125_(new AttributeModifier(BULLY_ARMOR_MODIFIER_UUID, "Bully skull armor", 2.0, AttributeModifier.Operation.ADDITION));
            }
            if (knockbackAttr != null) {
                knockbackAttr.m_22125_(new AttributeModifier(BULLY_KNOCKBACK_MODIFIER_UUID, "Bully skull knockback", 0.5, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Hoglin self = (Hoglin)this;
        ItemStack stack = player.m_21120_(hand);
        ItemStack currentArmor = this.inventory.m_8020_(1);
        ItemStack currentSaddle = this.inventory.m_8020_(0);
        ItemStack currentBanner = this.getBannerItem();
        ItemStack currentSkull = this.getSkullItem();
        boolean hasLauncher = this.getLavaLauncher();
        if (player.m_6144_()) {
            if (!currentBanner.m_41619_()) {
                if (!self.m_9236_().f_46443_) {
                    self.m_19983_(currentBanner);
                    this.setBannerItem(ItemStack.f_41583_);
                    self.m_5496_(SoundEvents.f_11678_, 0.5f, 1.2f);
                }
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
                return;
            }
            if (!currentSkull.m_41619_()) {
                if (!self.m_9236_().f_46443_) {
                    self.m_19983_(currentSkull);
                    this.setSkullItem(ItemStack.f_41583_);
                    self.m_5496_(SoundEvents.f_11679_, 0.6f, 1.0f);
                }
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
                return;
            }
            if (!currentArmor.m_41619_()) {
                self.m_19983_(currentArmor);
                this.inventory.m_6836_(1, ItemStack.f_41583_);
                this.setArmorEquipment(ItemStack.f_41583_);
                self.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
            if (!currentSaddle.m_41619_()) {
                self.m_19983_(currentSaddle);
                this.inventory.m_6836_(0, ItemStack.f_41583_);
                self.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
        }
        if (player.m_6144_() && stack.m_150930_(Items.f_42574_) && this.getLavaLauncher()) {
            if (!self.m_9236_().f_46443_) {
                this.setLavaLauncher(false);
                self.m_19983_(new ItemStack((ItemLike)AnimarmorModItems.LAVA_LAUNCHER.get()));
                self.m_5496_(SoundEvents.f_11914_, 0.7f, 1.0f);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
            return;
        }
        if (stack.m_41720_() == AnimarmorModItems.LAVA_LAUNCHER.get() && !hasLauncher && ((OwnableHoglin)self).isTame() && !this.isSaddled() && !this.m_6162_()) {
            this.setLavaLauncher(true);
            self.m_5496_(SoundEvents.f_11672_, 0.7f, 1.1f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
            return;
        }
        if (this.isBullySkull(stack) && currentSkull.m_41619_() && ((OwnableHoglin)self).isTame()) {
            ItemStack copy = stack.m_255036_(1);
            this.setSkullItem(copy);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            self.m_5496_(SoundEvents.f_11672_, 0.7f, 1.1f);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
            return;
        }
        if (stack.m_41720_() instanceof BannerItem && currentBanner.m_41619_() && ((OwnableHoglin)self).isTame()) {
            ItemStack copy = stack.m_255036_(1);
            this.setBannerItem(copy);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            self.m_5496_(SoundEvents.f_11678_, 0.5f, 1.2f);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)self.m_9236_().f_46443_));
            return;
        }
        if (this.isArmor(stack) && ((OwnableHoglin)self).isTame()) {
            ItemStack newArmor = stack.m_255036_(1);
            if (!currentArmor.m_41619_()) {
                self.m_19983_(currentArmor);
            }
            this.inventory.m_6836_(1, newArmor);
            this.setArmorEquipment(newArmor);
            self.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (stack.m_150930_(Items.f_42450_) && ((OwnableHoglin)self).isTame() && !this.isSaddled() && !this.m_6162_() && !hasLauncher) {
            this.inventory.m_6836_(0, stack.m_255036_(1));
            self.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (this.isSaddled() && ((OwnableHoglin)self).isTame() && !self.m_20160_()) {
            player.m_20329_((Entity)self);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        LivingEntity rider;
        Hoglin self = (Hoglin)this;
        if (this.m_6084_() && this.m_20160_() && (rider = this.m_6688_()) instanceof Player) {
            Player player = (Player)rider;
            this.m_146922_(player.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(player.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            float strafe = player.f_20900_ * 0.5f;
            float forward = player.f_20902_;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.canBeControlledByRider()) {
                this.m_7910_(this.m_245547_(player));
                super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
            } else {
                super.m_7023_(travelVector);
            }
            this.m_267651_(false);
            return;
        }
        super.m_7023_(travelVector);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity passenger = this.m_146895_();
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (this.isSaddled() && this.isTame()) {
                return player;
            }
        }
        return null;
    }

    public boolean canBeControlledByRider() {
        return this.isTame() && this.isSaddled() && this.m_6688_() instanceof Player;
    }

    protected float m_245547_(Player player) {
        if (!this.isTame() || this.m_6162_()) {
            return 0.0f;
        }
        float base = (float)this.m_21133_(Attributes.f_22279_) * 0.4f;
        if (player.m_20142_()) {
            base *= 1.4f;
        }
        base *= 1.0f + (float)this.getGreaseLevel() * 0.05f;
        return base *= this.getGrowthScale();
    }

    public boolean m_264410_() {
        return true;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void animarmor$saveData(CompoundTag nbt, CallbackInfo ci) {
        ItemStack saddle = this.inventory.m_8020_(0);
        ItemStack armor = this.inventory.m_8020_(1);
        ItemStack banner = this.getBannerItem();
        ItemStack skull = this.getSkullItem();
        if (!saddle.m_41619_()) {
            nbt.m_128365_("SaddleItem", (Tag)saddle.m_41739_(new CompoundTag()));
        }
        if (!armor.m_41619_()) {
            nbt.m_128365_("ArmorItem", (Tag)armor.m_41739_(new CompoundTag()));
        }
        if (!banner.m_41619_()) {
            nbt.m_128365_("BannerItem", (Tag)banner.m_41739_(new CompoundTag()));
        }
        if (!skull.m_41619_()) {
            nbt.m_128365_("SkullItem", (Tag)skull.m_41739_(new CompoundTag()));
        }
        if (this.getLavaLauncher()) {
            nbt.m_128379_("LavaLauncher", true);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void animarmor$loadData(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("SaddleItem", 10)) {
            ItemStack saddle = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SaddleItem"));
            this.inventory.m_6836_(0, saddle);
            this.f_19804_.m_135381_(DATA_SADDLED, (Object)(!saddle.m_41619_() ? 1 : 0));
        }
        if (nbt.m_128425_("ArmorItem", 10)) {
            this.inventory.m_6836_(1, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ArmorItem")));
        }
        if (nbt.m_128425_("BannerItem", 10)) {
            this.setBannerItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("BannerItem")));
        }
        this.updateContainerEquipment();
        if (nbt.m_128425_("SkullItem", 10)) {
            this.setSkullItem(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SkullItem")));
        }
        if (nbt.m_128441_("LavaLauncher")) {
            this.setLavaLauncher(nbt.m_128471_("LavaLauncher"));
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        Hoglin self = (Hoglin)this;
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            self.m_19983_(stack);
        }
        if (!this.getBannerItem().m_41619_()) {
            self.m_19983_(this.getBannerItem());
        }
        if (!this.getSkullItem().m_41619_()) {
            self.m_19983_(this.getSkullItem());
        }
    }

    @Override
    @Unique
    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    @Override
    public boolean canWearArmor() {
        return true;
    }

    @Override
    @Unique
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof HogArmorItem;
    }

    @Override
    @Unique
    public boolean isWearingArmor() {
        return !this.inventory.m_8020_(1).m_41619_();
    }

    @Override
    @Unique
    public ItemStack getBannerItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_BANNER_STACK);
    }

    @Override
    @Unique
    public void setBannerItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_BANNER_STACK, (Object)stack);
    }

    @Override
    @Unique
    public ItemStack getSkullItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_SKULL_STACK);
    }

    @Override
    @Unique
    public void setSkullItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_SKULL_STACK, (Object)stack);
        this.updateBullySkullEffects();
    }

    @Unique
    private boolean isBullySkull(ItemStack stack) {
        return stack.m_41720_() == AnimarmorModItems.HOG_SKULL.get();
    }

    @Override
    @Unique
    public boolean getLavaLauncher() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LAVA_LAUNCHER);
    }

    @Override
    @Unique
    public void setLavaLauncher(boolean value) {
        this.f_19804_.m_135381_(DATA_LAVA_LAUNCHER, (Object)value);
    }
}

