/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.UUID;
import net.mcreator.animarmor.OwnableHoglin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Hoglin.class})
public abstract class HoglinScalingMixin
extends Animal
implements OwnableHoglin {
    @Unique
    private static final EntityDataAccessor<Float> DATA_SCALE_ID = SynchedEntityData.m_135353_(HoglinScalingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final UUID SCALE_HEALTH_MODIFIER_UUID = UUID.fromString("f27f244b-1d4d-4e21-8b18-82b3950ac001");
    @Unique
    private static final UUID SCALE_DAMAGE_MODIFIER_UUID = UUID.fromString("7f1c44b2-05d0-42b5-9ed8-dba856dc0001");
    @Unique
    private static final float MAX_SCALE = 1.2f;

    protected HoglinScalingMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void animarmor$defineTamableData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_SCALE_ID, (Object)Float.valueOf(1.0f));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$saveTameData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128350_("Scale", this.getGrowthScale());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$loadTameData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("Scale")) {
            this.setGrowthScale(tag.m_128457_("Scale"));
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(DATA_SCALE_ID)) {
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getGrowthScale());
    }

    @Override
    @Unique
    public float getGrowthScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE_ID)).floatValue();
    }

    @Override
    @Unique
    public void setGrowthScale(float scale) {
        float clamped = Math.min(1.2f, Math.max(1.0f, scale));
        this.f_19804_.m_135381_(DATA_SCALE_ID, (Object)Float.valueOf(clamped));
        this.m_6210_();
        this.animarmor$updateStatsBasedOnScale();
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void forge$tameAndBreed(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack held = player.m_21120_(hand);
        if (this.isTame() && held.m_41614_()) {
            int foodValue = held.m_41720_().getFoodProperties(held, (LivingEntity)this).m_38744_();
            float growth = (float)foodValue * 0.015f;
            float newScale = Math.min(1.2f, this.getGrowthScale() + growth);
            if (newScale > this.getGrowthScale()) {
                this.setGrowthScale(newScale);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.m_146852_(GameEvent.f_157806_, (Entity)player);
            }
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Unique
    private void animarmor$updateStatsBasedOnScale() {
        AttributeInstance attackAttr;
        if (this.m_9236_().f_46443_) {
            return;
        }
        float scale = this.getGrowthScale();
        AttributeInstance healthAttr = this.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            double baseHealth = healthAttr.m_22115_();
            double scaleHealthBonus = 40.0 * (double)(scale - 1.0f);
            this.animarmor$applyModifier(Attributes.f_22276_, SCALE_HEALTH_MODIFIER_UUID, scaleHealthBonus, AttributeModifier.Operation.ADDITION);
            float ratio = this.m_21223_() / this.m_21233_();
            this.m_21153_(this.m_21233_() * ratio);
        }
        if ((attackAttr = this.m_21051_(Attributes.f_22281_)) != null) {
            double baseDamage = attackAttr.m_22115_();
            double scaleDamageBonus = 6.0 * (double)(scale - 1.0f);
            this.animarmor$applyModifier(Attributes.f_22281_, SCALE_DAMAGE_MODIFIER_UUID, scaleDamageBonus, AttributeModifier.Operation.ADDITION);
        }
    }

    @Unique
    private void animarmor$applyModifier(Attribute attribute, UUID uuid, double value, AttributeModifier.Operation operation) {
        AttributeInstance attr = this.m_21051_(attribute);
        if (attr == null) {
            return;
        }
        AttributeModifier old = attr.m_22111_(uuid);
        if (old != null) {
            attr.m_22130_(old);
        }
        if (value != 0.0) {
            attr.m_22125_(new AttributeModifier(uuid, "AnimArmor scaling", value, operation));
        }
    }
}

