/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.Optional;
import java.util.UUID;
import net.mcreator.animarmor.OwnableHoglin;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Hoglin.class})
public abstract class HoglinTamingMixin
extends Animal
implements OwnableEntity,
OwnableHoglin {
    @Unique
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(HoglinTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(HoglinTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(HoglinTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Unique
    private boolean orderedToSit;

    @Shadow
    protected abstract boolean m_34557_();

    @Shadow
    protected abstract void m_34564_(boolean var1);

    protected HoglinTamingMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void animarmor$defineTamableData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$saveTameData(CompoundTag tag, CallbackInfo ci) {
        if (this.m_21805_() != null) {
            tag.m_128362_("Owner", this.m_21805_());
        }
        tag.m_128379_("Sitting", this.orderedToSit);
        tag.m_128405_("Variant", this.getVariant());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$loadTameData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
            this.setTame(true);
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    @Unique
    @javax.annotation.Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    @Unique
    public void setOwnerUUID(@javax.annotation.Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @Override
    @javax.annotation.Nullable
    public LivingEntity m_269323_() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity != null && entity.m_20148_().equals(this.m_21805_());
    }

    @Unique
    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CriteriaTriggers.f_10590_.m_68829_(sp, (Animal)this);
        }
    }

    @Override
    @Unique
    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    @Unique
    public void setTame(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        return this.isOwnedBy(entity) ? false : super.m_6779_(entity);
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamable;
        OwnableHoglin ownable;
        Hoglin otherHoglin;
        if (target == owner) {
            return false;
        }
        if (target instanceof Hoglin && (otherHoglin = (Hoglin)target) instanceof OwnableHoglin && (ownable = (OwnableHoglin)otherHoglin).isTame()) {
            if (this.m_269323_() != null && this.m_269323_().equals((Object)ownable.m_269323_())) {
                return false;
            }
            return false;
        }
        if (owner instanceof Player) {
            Player targetPlayer;
            Player player = (Player)owner;
            if (target instanceof Player && !player.m_7099_(targetPlayer = (Player)target)) {
                return false;
            }
        }
        return !(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).m_21824_();
    }

    public boolean m_7307_(Entity other) {
        if (this.isTame()) {
            LivingEntity owner = this.m_269323_();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                return owner.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public Team m_5647_() {
        LivingEntity owner;
        if (this.isTame() && (owner = this.m_269323_()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void forge$tameAndBreed(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_150930_(Items.f_42588_)) {
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (!this.isTame() && this.m_6162_()) {
                    this.tame(player);
                    this.m_34564_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else if (this.isTame() && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(4.0f);
                    this.m_146852_(GameEvent.f_157806_, (Entity)player);
                } else if (!this.m_6162_() && !this.isTame()) {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (this.isTame() && held.m_41619_() && player.m_6144_()) {
            boolean sit = !this.isOrderedToSit();
            this.setOrderedToSit(sit);
            this.setInSittingPose(sit);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12233_, this.m_5720_(), 0.5f, sit ? 0.8f : 1.2f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
    }

    @Inject(method={"isConverting"}, at={@At(value="HEAD")}, cancellable=true)
    private void forge$disableZombificationWhenTamed(CallbackInfoReturnable<Boolean> cir) {
        if (this.isTame()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean sit) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (sit) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void setOrderedToSit(boolean sit) {
        this.orderedToSit = sit;
    }

    @Override
    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void animarmor$standUpWhenHit(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.isTame() && this.isOrderedToSit()) {
            this.setOrderedToSit(false);
            this.setInSittingPose(false);
        }
    }

    @Override
    @Unique
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    @Override
    @Unique
    public void setVariant(int value) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)Math.min(4, Math.max(1, value)));
    }

    @Inject(method={"getBreedOffspring"}, at={@At(value="RETURN")}, cancellable=true)
    private void animarmor$inheritVariantFromParents(ServerLevel level, AgeableMob otherParent, CallbackInfoReturnable<AgeableMob> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof Hoglin) {
            Hoglin baby = (Hoglin)object;
            if (otherParent instanceof Hoglin) {
                OwnableHoglin ownableParent;
                int chosenVariant;
                int variant2;
                Hoglin other = (Hoglin)otherParent;
                int variant1 = this.getVariant();
                if (other instanceof OwnableHoglin) {
                    OwnableHoglin ownable2 = (OwnableHoglin)other;
                    v0 = ownable2.getVariant();
                } else {
                    v0 = variant2 = 1;
                }
                if (variant1 == variant2) {
                    chosenVariant = variant1;
                } else if (this.m_9236_().f_46441_.m_188501_() < 0.1f) {
                    chosenVariant = this.m_9236_().f_46441_.m_188503_(4) + 1;
                } else {
                    int n = chosenVariant = this.m_9236_().f_46441_.m_188499_() ? variant1 : variant2;
                }
                if (baby instanceof OwnableHoglin) {
                    OwnableHoglin ownableBaby = (OwnableHoglin)baby;
                    ownableBaby.setVariant(chosenVariant);
                }
                if (this.isTame() && other instanceof OwnableHoglin && (ownableParent = (OwnableHoglin)other).isTame()) {
                    baby.m_34564_(true);
                }
            }
        }
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="TAIL")}, cancellable=true)
    private void animarmor$setRandomVariantOnSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (!this.m_9236_().f_46443_ && this.getVariant() == 1) {
            this.setVariant(this.m_9236_().f_46441_.m_188503_(4) + 1);
        }
    }
}

