/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.animarmor.BunnyArmorItem;
import net.mcreator.animarmor.OwnableRabbit;
import net.mcreator.animarmor.RabbitFollowOwnerGoal;
import net.mcreator.animarmor.item.NetheriteBunnyArmorItem;
import net.mcreator.animarmor.mixins.RabbitAccessorMixin;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Rabbit.class})
public abstract class RabbitTamingMixin
extends Animal
implements OwnableEntity,
OwnableRabbit {
    @Unique
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(RabbitTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(RabbitTamingMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Unique
    private boolean orderedToSit;
    @Unique
    private boolean removedAvoidGoals = false;
    @Unique
    protected SimpleContainer inventory;
    @Unique
    private static final int INV_SLOT_ARMOR = 0;
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("07b5e37c-3f7f-4e08-915f-5c88d5f9a77e");

    protected RabbitTamingMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void animarmor$addFollowOwnerGoal(CallbackInfo ci) {
        Rabbit rabbit = (Rabbit)this;
        rabbit.f_21345_.m_25352_(5, (Goal)new RabbitFollowOwnerGoal(rabbit, 1.0, 4.0f, 2.0f, false));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void animarmor$defineTamableData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$saveTameData(CompoundTag tag, CallbackInfo ci) {
        if (this.m_21805_() != null) {
            tag.m_128362_("Owner", this.m_21805_());
        }
        tag.m_128379_("Sitting", this.orderedToSit);
        ItemStack armor = this.inventory.m_8020_(0);
        if (!armor.m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)armor.m_41739_(new CompoundTag()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void forge$loadTameData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128403_("Owner")) {
            this.setOwnerUUID(tag.m_128342_("Owner"));
            this.setTame(true);
        }
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        if (tag.m_128425_("ArmorItem", 10)) {
            ItemStack armor = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"));
            this.inventory.m_6836_(0, armor);
            this.setArmorEquipment(armor);
        }
    }

    @Override
    @Unique
    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Override
    @Unique
    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    @Override
    @Nullable
    public LivingEntity m_269323_() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity != null && entity.m_20148_().equals(this.m_21805_());
    }

    @Unique
    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CriteriaTriggers.f_10590_.m_68829_(sp, (Animal)this);
        }
    }

    @Override
    @Unique
    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    @Override
    @Unique
    public void setTame(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (value) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    public boolean m_7307_(Entity other) {
        if (this.isTame()) {
            LivingEntity owner = this.m_269323_();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                return owner.m_7307_(other);
            }
        }
        return super.m_7307_(other);
    }

    public Team m_5647_() {
        LivingEntity owner;
        if (this.isTame() && (owner = this.m_269323_()) != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Rabbit self = (Rabbit)this;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ItemStack currentArmor = this.inventory.m_8020_(0);
        if (stack.m_150930_(Items.f_42677_) && !this.isTame()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (!this.isTame()) {
                    this.tame(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_5634_(4.0f);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTame() && stack.m_41619_() && player.m_6144_()) {
            boolean sit = !this.isOrderedToSit();
            this.setOrderedToSit(sit);
            this.setInSittingPose(sit);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12354_, this.m_5720_(), 0.5f, sit ? 0.8f : 1.2f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.isTame() && player.m_6144_() && !currentArmor.m_41619_()) {
            self.m_19983_(currentArmor);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
            self.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (this.isTame() && item instanceof BunnyArmorItem) {
            BunnyArmorItem armorItem = (BunnyArmorItem)item;
            if (!currentArmor.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)currentArmor)) {
                return InteractionResult.PASS;
            }
            ItemStack newArmor = stack.m_255036_(1);
            if (!currentArmor.m_41619_()) {
                self.m_19983_(currentArmor);
            }
            this.inventory.m_6836_(0, newArmor);
            this.setArmorEquipment(newArmor);
            self.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void animarmor$handleHeartEvent(byte eventId, CallbackInfo ci) {
        if (eventId == 7) {
            for (int i = 0; i < 7; ++i) {
                double dx = this.f_19796_.m_188583_() * 0.02;
                double dy = this.f_19796_.m_188583_() * 0.02;
                double dz = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), dx, dy, dz);
            }
        }
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    @Override
    public void setInSittingPose(boolean sit) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (sit) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void setOrderedToSit(boolean sit) {
        this.orderedToSit = sit;
    }

    @Override
    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ItemStack armor;
        if (this.isTame() && this.isOrderedToSit()) {
            this.setOrderedToSit(false);
            this.setInSittingPose(false);
        }
        if ((armor = this.m_6844_(EquipmentSlot.CHEST)).m_41720_() instanceof NetheriteBunnyArmorItem && (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_))) {
            this.m_7311_(0);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void animarmor$freezeWhenSitting(CallbackInfo ci) {
        if (this.isTame() && this.isOrderedToSit()) {
            this.m_21573_().m_26573_();
            ((Rabbit.RabbitJumpControl)this.f_21343_).m_29758_(false);
            this.f_20899_ = false;
            ((RabbitAccessorMixin)((Object)this)).setJumpTicks(0);
            ((RabbitAccessorMixin)((Object)this)).setJumpDuration(0);
            ci.cancel();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void animarmor$stopMovementWhenSitting(CallbackInfo ci) {
        if (this.isTame() && this.isOrderedToSit()) {
            this.m_21573_().m_26573_();
            ((Rabbit.RabbitJumpControl)this.f_21343_).m_29758_(false);
            this.f_20899_ = false;
            ((RabbitAccessorMixin)((Object)this)).setJumpTicks(0);
            ((RabbitAccessorMixin)((Object)this)).setJumpDuration(0);
            this.f_21342_.m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void animarmor$createRabbitInventory(EntityType<? extends Rabbit> type, Level level, CallbackInfo ci) {
        this.createInventory();
    }

    @Unique
    private void createInventory() {
        SimpleContainer old = this.inventory;
        this.inventory = new SimpleContainer(1);
        if (old != null) {
            old.m_19181_(this::containerChanged);
            ItemStack prev = old.m_8020_(0);
            if (!prev.m_41619_()) {
                this.inventory.m_6836_(0, prev.m_41777_());
            }
        }
        this.inventory.m_19164_(this::containerChanged);
        this.updateContainerEquipment();
    }

    @Unique
    private void containerChanged(Container container) {
        this.updateContainerEquipment();
    }

    @Unique
    private void updateContainerEquipment() {
        Rabbit self = (Rabbit)this;
        if (!self.m_9236_().f_46443_) {
            this.setArmorEquipment(this.inventory.m_8020_(0));
        }
    }

    @Unique
    protected void setArmorEquipment(ItemStack armor) {
        int protection;
        Rabbit self = (Rabbit)this;
        self.m_8061_(EquipmentSlot.CHEST, armor);
        self.m_21409_(EquipmentSlot.CHEST, 0.0f);
        AttributeInstance attr = self.m_21051_(Attributes.f_22284_);
        if (attr == null) {
            return;
        }
        attr.m_22120_(ARMOR_MODIFIER_UUID);
        if (this.isArmor(armor) && (protection = ((BunnyArmorItem)armor.m_41720_()).getProtection()) > 0) {
            attr.m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Rabbit armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        ItemStack armor = this.m_6844_(EquipmentSlot.CHEST);
        if (!armor.m_41619_()) {
            this.m_19983_(armor.m_41777_());
            this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            this.setArmorEquipment(ItemStack.f_41583_);
        }
    }

    @Unique
    public boolean canWearArmor() {
        return true;
    }

    @Unique
    public boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof BunnyArmorItem;
    }

    @Unique
    public boolean isWearingArmor() {
        return !this.inventory.m_8020_(0).m_41619_();
    }
}

