/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animarmor.mixins;

import javax.annotation.Nullable;
import net.mcreator.animarmor.ArmoredVindicator;
import net.mcreator.animarmor.UseShieldGoal;
import net.mcreator.animarmor.init.AnimarmorModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ToolActions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Vindicator.class})
public abstract class VindicatorArmorMixin
extends AbstractIllager
implements ArmoredVindicator {
    private static final String TAG_ROYAL_GUARD = "RoyalGuard";
    private int shieldCooldownTime;
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_ROYAL_GUARD = SynchedEntityData.m_135353_(Vindicator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected VindicatorArmorMixin(EntityType<? extends AbstractIllager> type, Level level) {
        super(type, level);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        this.m_21553_(true);
        this.shieldCooldownTime = 0;
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void addShieldGoal(CallbackInfo ci) {
        Vindicator self = (Vindicator)this;
        self.f_21345_.m_25352_(1, (Goal)new UseShieldGoal((PathfinderMob)this, 10.0, 60, 120, 10, 60, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ROYAL_GUARD, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void animarmor$saveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_(TAG_ROYAL_GUARD, ((Boolean)this.f_19804_.m_135370_(DATA_ROYAL_GUARD)).booleanValue());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void animarmor$loadData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_(TAG_ROYAL_GUARD)) {
            boolean flag = tag.m_128471_(TAG_ROYAL_GUARD);
            this.f_19804_.m_135381_(DATA_ROYAL_GUARD, (Object)flag);
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
            this.m_6210_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(DATA_ROYAL_GUARD)) {
            this.m_6210_();
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        boolean royal = (Boolean)this.f_19804_.m_135370_(DATA_ROYAL_GUARD);
        if (royal) {
            EntityDimensions base = super.m_6972_(pose);
            return EntityDimensions.m_20395_((float)(base.f_20377_ * 1.1f), (float)(base.f_20378_ * 1.1f));
        }
        return super.m_6972_(pose);
    }

    @Override
    @Unique
    public boolean isRoyalGuard() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ROYAL_GUARD);
    }

    @Override
    @Unique
    public void setRoyalGuard(boolean royal) {
        this.f_19804_.m_135381_(DATA_ROYAL_GUARD, (Object)royal);
        this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
        this.m_6210_();
    }

    public boolean m_7252_(ItemStack stack) {
        return super.m_7252_(stack) || stack.m_41720_() instanceof ArmorItem;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)Raid.m_37779_())) {
            super.m_7581_(itemEntity);
            return;
        }
        if (this.m_7252_(stack)) {
            super.m_7581_(itemEntity);
        }
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="TAIL")}, cancellable=false)
    private void animarmor$equipHelmet(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag entityNbt, CallbackInfoReturnable<SpawnGroupData> cir) {
        Vindicator self = (Vindicator)this;
        double chance = 0.15;
        Raid raid = self.m_37885_();
        int wave = raid != null ? raid.m_37771_() : 0;
        chance += (double)wave * 0.05;
        chance = Math.min(chance, 0.95);
        if (level.m_213780_().m_188500_() < chance) {
            ItemStack helmet = new ItemStack((ItemLike)AnimarmorModItems.VINDICATOR_HELMET.get());
            if (wave >= 4) {
                int enchantLevel = switch (wave) {
                    case 4 -> 5;
                    case 5 -> 8;
                    case 6 -> 15;
                    case 7 -> 20;
                    case 8 -> 30;
                    default -> 0;
                };
                if (enchantLevel > 0) {
                    EnchantmentHelper.m_220292_((RandomSource)level.m_213780_(), (ItemStack)helmet, (int)enchantLevel, (boolean)true);
                }
            }
            self.m_8061_(EquipmentSlot.HEAD, helmet);
            self.m_21409_(EquipmentSlot.HEAD, 0.05f);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vindicator self = (Vindicator)this;
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
        if (self.m_21254_()) {
            self.m_21573_().m_26573_();
        }
    }

    protected void m_6677_(DamageSource damageSource) {
        if (this.shieldCooldownTime == 100) {
            this.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        } else if (this.m_21254_()) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        } else {
            super.m_6677_(damageSource);
        }
    }

    public void m_6728_(LivingEntity livingEntity) {
        super.m_6728_(livingEntity);
        if (livingEntity.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void m_7909_(float amount) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && amount >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)amount);
            InteractionHand hand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, living -> living.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.f_19796_.m_188501_() < f) {
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            this.shieldCooldownTime = 100;
            this.m_5810_();
            this.m_9236_().m_7605_((Entity)this, (byte)30);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }
}

