/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GaugeChunkWidget
extends GaugeWidget {
    protected boolean spriteChanged = true;
    protected int imageWidth;
    protected int imageHeight;

    public GaugeChunkWidget(int x, int y, int width, int height, Component message, ResourceLocation sprite, @Nullable ResourceLocation overlay_sprite, long capacity, GaugeWidget.Direction4 direction) {
        super(x, y, width, height, message, sprite, overlay_sprite, capacity, direction);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.spriteChanged) {
            SpriteContents contents = guiGraphics.sprites.getSprite(this.sprite).contents();
            this.imageHeight = contents.height();
            this.imageWidth = contents.width();
            this.spriteChanged = false;
        }
        switch (this.DIRECTION) {
            case DOWN_UP: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.imageWidth, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.imageWidth * j, this.getY() + this.getHeight() - i, this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(this.sprite, x, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.width - x, this.getY() + this.getHeight() - i, x, i);
                break;
            }
            case UP_DOWN: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.imageWidth, this.getHeight(), 0, 0, this.getX() + this.imageWidth * j, this.getY(), this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(this.sprite, x, this.getHeight(), 0, 0, this.getX() + this.width - x, this.getY(), x, i);
                break;
            }
            case LEFT_RIGHT: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.getWidth(), this.imageHeight, 0, 0, this.getX(), this.getY() + this.imageHeight * j, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(this.sprite, this.getWidth(), y, 0, 0, this.getX(), this.getY() + this.height - y, i, y);
                break;
            }
            case RIGHT_LEFT: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(this.sprite, this.getWidth(), this.imageHeight, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.imageHeight * j, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(this.sprite, this.getWidth(), y, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.height - y, i, y);
            }
        }
        if (this.overlay_sprite != null) {
            guiGraphics.blitSprite(this.overlay_sprite, this.getX(), this.getY(), this.width, this.height);
        }
    }

    @Override
    public void updateSprite(ResourceLocation sprite) {
        super.updateSprite(sprite);
        this.spriteChanged = true;
    }
}

