/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.menus.slot.FluidContainerSlot;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class FluidTankMenu
extends BaseContainer {
    private final Container inventory;
    private final FluidTankBlockEntity blockEntity;

    public static FluidTankMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        return new FluidTankMenu(syncId, inventory, (Container)new SimpleContainer(2), (FluidTankBlockEntity)inventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public FluidTankMenu(int syncId, Inventory playerInventory, Container container, FluidTankBlockEntity entity) {
        super((MenuType)MenuTypesRegistry.FLUID_TANK_MENU.get(), syncId, 2, playerInventory, 10, 106);
        FluidTankMenu.checkContainerSize((Container)container, (int)2);
        this.inventory = container;
        this.blockEntity = entity;
        this.addSlot(new FluidContainerSlot(this.inventory, 0, 52, 50, false));
        this.addSlot(new FluidContainerSlot(this.inventory, 1, 112, 50, false));
    }

    public FluidTankBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }
}

