/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.common.entities.vehicles.base.AbstractRoverBase;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SyncRoverPacket
implements CustomPacketPayload {
    private final boolean forward;
    private final boolean backward;
    private final boolean left;
    private final boolean right;
    private final UUID uuid;
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRoverPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncRoverPacket>(){

        public SyncRoverPacket decode(RegistryFriendlyByteBuf buf) {
            return SyncRoverPacket.fromBytes(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncRoverPacket packet) {
            packet.toBytes(buf);
        }
    };

    public SyncRoverPacket(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = player.getUUID();
    }

    public SyncRoverPacket(boolean forward, boolean backward, boolean left, boolean right, UUID uuid) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = uuid;
    }

    public static SyncRoverPacket fromBytes(RegistryFriendlyByteBuf buf) {
        boolean forward = buf.readBoolean();
        boolean backward = buf.readBoolean();
        boolean left = buf.readBoolean();
        boolean right = buf.readBoolean();
        UUID uuid = buf.readUUID();
        return new SyncRoverPacket(forward, backward, left, right, uuid);
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.backward);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.writeUUID(this.uuid);
    }

    public CustomPacketPayload.Type<SyncRoverPacket> type() {
        return NetworkRegistry.SYNC_ROVER_CONTROLS;
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        AbstractRoverBase rover;
        ServerPlayer serverPlayer;
        Entity entity;
        Player player = packetContext.getPlayer();
        if (player instanceof ServerPlayer && (entity = (serverPlayer = (ServerPlayer)player).getVehicle()) instanceof AbstractRoverBase && (rover = (AbstractRoverBase)entity).getUUID().equals(this.uuid)) {
            rover.updateControls(this.forward, this.backward, this.left, this.right, (Player)serverPlayer);
        }
    }
}

