/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OxygenRoom {
    private final BlockPos distributorPos;
    public final Set<BlockPos> oxygenatedPositions;
    private final ServerLevel level;

    public OxygenRoom(ServerLevel level, BlockPos distributorPos) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = new HashSet<BlockPos>();
        this.level = level;
    }

    public BlockPos getDistributorPosition() {
        return this.distributorPos;
    }

    public OxygenDistributorBlockEntity getDistributorBlockEntity() {
        OxygenDistributorBlockEntity distributor;
        BlockEntity blockEntity = this.level.getBlockEntity(this.distributorPos);
        return blockEntity instanceof OxygenDistributorBlockEntity ? (distributor = (OxygenDistributorBlockEntity)blockEntity) : null;
    }

    public void tick() {
        OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
        if (distributor == null) {
            return;
        }
        LinkedList<BlockPos> toExplore = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>(this.oxygenatedPositions);
        HashSet<BlockPos> newPositions = new HashSet<BlockPos>();
        for (Direction direction : Direction.values()) {
            BlockPos rel = this.distributorPos.relative(direction);
            if (visited.contains(rel) || !this.level.getBlockState(rel).isAir()) continue;
            toExplore.offer(rel);
            visited.add(rel);
        }
        while (!toExplore.isEmpty()) {
            BlockPos currentPos = (BlockPos)toExplore.poll();
            if (!this.level.getBlockState(currentPos).isAir()) continue;
            newPositions.add(currentPos);
            for (Direction direction : Direction.values()) {
                BlockPos rel = currentPos.relative(direction);
                if (visited.contains(rel)) continue;
                visited.add(rel);
                int HalfRoomSize = Stellaris.CONFIG.oxygenConfig.maxOxygenRoomSize / 2;
                if (Math.abs(rel.getX() - this.distributorPos.getX()) > HalfRoomSize || Math.abs(rel.getY() - this.distributorPos.getY()) > HalfRoomSize || Math.abs(rel.getZ() - this.distributorPos.getZ()) > HalfRoomSize) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).addRoomToCheckIfOpen(rel, this);
                    continue;
                }
                if (!this.level.getBlockState(rel).isAir()) continue;
                toExplore.offer(rel);
            }
        }
        for (BlockPos pos : newPositions) {
            if (this.oxygenatedPositions.contains(pos) || !distributor.useOxygenAndEnergy()) continue;
            this.oxygenatedPositions.add(pos);
            GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(pos);
        }
    }

    public void removeOxygenInRoom() {
        this.oxygenatedPositions.clear();
    }

    public boolean hasOxygenAt(BlockPos pos) {
        return this.oxygenatedPositions.contains(pos);
    }

    public boolean breathOxygenAt(BlockPos pos) {
        if (!Stellaris.CONFIG.oxygenConfig.enableOxygenSystem) {
            return true;
        }
        if (this.hasOxygenAt(pos)) {
            OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
            if (this.getDistributorBlockEntity() == null || !distributor.useOxygenAndEnergy()) {
                this.oxygenatedPositions.remove(pos);
            }
            return true;
        }
        return false;
    }
}

