/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.ConfigList;
import com.st0x0ef.stellaris.client.screens.components.StateButton;
import com.st0x0ef.stellaris.common.config.CommonConfig;
import com.st0x0ef.stellaris.common.config.ConfigManager;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8662;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends class_437 {
    public static final class_2960 TEXTURE = ResourceLocationUtils.texture("/item/engine_fan");
    private final class_437 parent;
    public final class_8132 layout = new class_8132((class_437)this);
    protected ConfigList configList;

    public ConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Stellaris Option"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.addTitle();
        this.addFooter();
        this.configList = (ConfigList)this.layout.method_48999((class_8021)new ConfigList(this.field_22787, this.field_22789, this));
        Class<?> clazz = Stellaris.CONFIG.getClass();
        this.addFields(clazz.getFields(), Stellaris.CONFIG, this.configList, 0);
        this.layout.method_48206(arg_0 -> ((ConfigScreen)this).method_37063(arg_0));
        this.layout.method_48222();
    }

    protected void addTitle() {
        this.layout.method_57726(this.field_22785, this.field_22793);
    }

    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
    }

    private void addFields(Field[] fields, Object object, ConfigList configList, int recursionDepth) {
        for (Field field : fields) {
            try {
                Object value = field.get(object);
                String name = field.getName();
                if (field.isAnnotationPresent(ConfigManager.InnerConfig.class)) {
                    configList.addBig((class_339)new class_7842((class_2561)class_2561.method_43471((String)("config.stellaris." + name)).method_27692(class_124.field_1067), this.field_22793));
                    this.addFields(field.getType().getFields(), field.get(object), configList, recursionDepth + 1);
                    continue;
                }
                configList.addSmall((class_339)new class_7842((class_2561)class_2561.method_43471((String)("config.stellaris." + name)), this.field_22793), this.addTypeWidget(field, object, value, (class_2561)class_2561.method_43471((String)("config.stellaris." + name + ".desc"))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.configList != null) {
            this.configList.method_57712(this.field_22789, this.layout);
        }
    }

    public void method_25419() {
        this.saveConfig();
        this.playToast((class_2561)class_2561.method_43470((String)"Config Saved"), (class_2561)class_2561.method_43470((String)"The Stellaris config has been saved"));
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
    }

    public void method_25432() {
        this.field_22787.field_1690.method_1640();
    }

    public void playToast(class_2561 title, class_2561 description) {
        this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, title, description));
    }

    private class_339 addTypeWidget(Field field, Object configInstance, Object value, class_2561 description) {
        String fieldName = field.getName();
        if (value instanceof Boolean) {
            Boolean boolVal = (Boolean)value;
            StateButton button = new StateButton(0, 0, 150, 20, (class_2561)class_2561.method_43470((String)"StateButton"), boolVal);
            button.method_47400(class_7919.method_47407((class_2561)description));
            return button;
        }
        if (value instanceof Number || value instanceof String) {
            class_342 editBox = new class_342(this.field_22793, 100, 15, (class_2561)class_2561.method_43470((String)fieldName));
            editBox.method_47400(class_7919.method_47407((class_2561)description));
            editBox.method_1852(value.toString());
            editBox.method_1863(str -> {
                try {
                    Object converted = this.convertValue((String)str, field.getType());
                    field.set(configInstance, converted);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return editBox;
        }
        class_8662 unsupported = this.stellarisConfigButton(20);
        unsupported.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Unsupported field type")));
        return unsupported;
    }

    private Object convertValue(String str, Class<?> type) {
        return switch (type.getSimpleName()) {
            case "int", "Integer" -> Integer.parseInt(str);
            case "long", "Long" -> Long.parseLong(str);
            case "double", "Double" -> Double.parseDouble(str);
            case "float", "Float" -> Float.valueOf(Float.parseFloat(str));
            default -> str;
        };
    }

    private void saveConfig() {
        Path configPath = Platform.getConfigFolder().resolve("stellaris-config.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            Stellaris.GSON.toJson((Object)Stellaris.CONFIG, CommonConfig.class, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.playToast((class_2561)class_2561.method_43470((String)"Config Error"), (class_2561)class_2561.method_43470((String)"Failed to save Stellaris config"));
        }
    }

    private class_8662 stellarisConfigButton(int i) {
        return class_8662.method_52723((class_2561)class_2561.method_43470((String)"Config"), button -> {
            Path path = Path.of(String.valueOf(Platform.getConfigFolder()) + "/stellaris.json", new String[0]);
            class_156.method_668().method_673(path.toUri());
        }, (boolean)true).method_52725(i).method_52727(TEXTURE, 16, 16).method_52724();
    }
}

