/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public abstract class MoveableWindow
extends class_339
implements class_4068,
class_364 {
    private boolean dragging = false;
    private int windowX;
    private int windowY;
    public double dragOffsetX = 0.0;
    public double dragOffsetY = 0.0;
    public int moveLimit;
    public final Map<class_339, int[]> initialWidgetOffsets = new HashMap<class_339, int[]>();
    public Render render;
    public class_437 parent;

    public MoveableWindow(int width, int height, class_2561 message, class_437 parent) {
        this(width, height, message, parent, null);
    }

    public MoveableWindow(int width, int height, class_2561 message, class_437 parent, Render render) {
        super(parent.field_22789 / 2 - width / 2, parent.field_22790 / 2 - height / 2, width, height, message);
        this.parent = parent;
        this.render = render;
        this.windowX = this.method_46426();
        this.windowY = this.method_46427();
        this.moveLimit = height;
    }

    public abstract void renderWindow(class_332 var1, int var2, int var3, float var4);

    public void init() {
    }

    public void close() {
        this.changeVisibility(false);
    }

    public void renderWidgets(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (class_339 widget : this.initialWidgetOffsets.keySet()) {
            widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public Consumer<MoveableWindow> resize(class_310 minecraft, int width, int height) {
        return window -> {};
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.render != null) {
            this.render.render(this);
        }
        this.renderWindow(guiGraphics, mouseX, mouseY, partialTick);
        this.updateWidgetPositions();
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.mouseInside(mouseX, mouseY)) {
            this.dragging = true;
            this.dragOffsetX = mouseX - (double)this.windowX;
            this.dragOffsetY = mouseY - (double)this.windowY;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.windowX = (int)(mouseX - this.dragOffsetX);
            this.windowY = (int)(mouseY - this.dragOffsetY);
            this.method_46421(this.windowX);
            this.method_46419(this.windowY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateWidgetPositions() {
        for (class_339 widget : this.initialWidgetOffsets.keySet()) {
            int[] offset = this.initialWidgetOffsets.get(widget);
            widget.method_46421(this.windowX + offset[0]);
            widget.method_46419(this.windowY + offset[1]);
        }
    }

    public void changeVisibility(boolean visible) {
        this.field_22764 = visible;
        for (class_339 widget : this.initialWidgetOffsets.keySet()) {
            widget.field_22764 = visible;
        }
    }

    public <T extends class_339> void addWidget(T widget) {
        int relativeX = widget.method_46426() - this.windowX;
        int relativeY = widget.method_46427() - this.windowY;
        this.initialWidgetOffsets.put(widget, new int[]{relativeX, relativeY});
    }

    public boolean mouseInside(double mouseX, double mouseY) {
        return mouseX >= (double)this.windowX && mouseX <= (double)(this.windowX + this.field_22758) && mouseY >= (double)this.windowY && mouseY <= (double)(this.windowY + this.getMoveLimit());
    }

    public int getWindowX() {
        return this.windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    public int getMoveLimit() {
        return this.field_22759;
    }

    public static interface Render {
        public void render(MoveableWindow var1);
    }
}

