/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.data.recipes.FuelRefineryRecipe;
import com.st0x0ef.stellaris.common.data.recipes.input.FluidInput;
import com.st0x0ef.stellaris.common.menus.FuelRefineryMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacket;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelRefineryBlockEntity
extends BaseEnergyContainerBlockEntity
implements FluidProvider.BLOCK {
    private final SingleFluidStorage inputTank;
    private final SingleFluidStorage outputFuelTank;
    private final SingleFluidStorage outputDieselTank;
    private final class_1863.class_7266<FluidInput, FuelRefineryRecipe> cachedCheck = class_1863.method_42302((class_3956)((class_3956)RecipesRegistry.FUEL_REFINERY_TYPE.get()));

    public FuelRefineryBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.FUEL_REFINERY.get(), pos, state);
        this.inputTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.method_5431();
                if (FuelRefineryBlockEntity.this.field_11863 != null && FuelRefineryBlockEntity.this.field_11863.method_8503() != null && !FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571(), (class_8710)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.method_11016(), class_2350.field_11036));
                }
            }

            @Override
            public boolean isFluidValid(int tank, FluidStack stack) {
                return stack.getFluid().method_15780((class_3611)FluidRegistry.OIL_STILL.get());
            }
        };
        this.outputFuelTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.method_5431();
                if (FuelRefineryBlockEntity.this.field_11863 != null && FuelRefineryBlockEntity.this.field_11863.method_8503() != null && !FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571(), (class_8710)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.method_11016(), class_2350.field_11043));
                }
            }
        };
        this.outputDieselTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.method_5431();
                if (FuelRefineryBlockEntity.this.field_11863 != null && FuelRefineryBlockEntity.this.field_11863.method_8503() != null && !FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.field_11863.method_8503().method_3760().method_14571(), (class_8710)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.method_11016(), class_2350.field_11035));
                }
            }
        };
    }

    @Override
    public void tick() {
        FluidUtil.moveFluidToItem(0, this.inputTank, 1, (class_2371<class_1799>)this.items, 1000L);
        FluidUtil.moveFluidToItem(0, this.outputFuelTank, 2, (class_2371<class_1799>)this.items, 1000L);
        FluidUtil.moveFluidToItem(0, this.outputDieselTank, 4, (class_2371<class_1799>)this.items, 1000L);
        FluidUtil.moveFluidFromItem(0, 0, (class_2371<class_1799>)this.items, this.inputTank, 1000L);
        if (this.field_11863 == null) {
            return;
        }
        Optional recipeHolder = this.cachedCheck.method_42303((class_9695)new FluidInput(this.field_11863.method_8321(this.method_11016())), this.field_11863);
        if (recipeHolder.isPresent()) {
            FuelRefineryRecipe recipe = (FuelRefineryRecipe)((class_8786)recipeHolder.get()).comp_1933();
            if (this.energyContainer.getEnergy() >= recipe.energy() && this.inputTank.getFluidValueInTank() >= recipe.ingredientStack().getAmount() && (this.outputFuelTank.getFluidInTank(0).isEmpty() || this.outputFuelTank.getFluidInTank(0).isFluidEqual(recipe.fuelStack())) && (this.outputDieselTank.getFluidInTank(0).isEmpty() || this.outputDieselTank.getFluidInTank(0).isFluidEqual(recipe.dieselStack()))) {
                boolean shouldUseEnergyAndDrainOil = false;
                if (this.outputFuelTank.getFluidValueInTank() + recipe.fuelStack().getAmount() < this.outputFuelTank.getTankCapacity(0)) {
                    this.outputFuelTank.fill(recipe.fuelStack().copy(), false);
                    shouldUseEnergyAndDrainOil = true;
                }
                if (this.outputDieselTank.getFluidValueInTank() + recipe.dieselStack().getAmount() < this.outputDieselTank.getTankCapacity(0)) {
                    this.outputDieselTank.fill(recipe.dieselStack().copy(), false);
                    shouldUseEnergyAndDrainOil = true;
                }
                if (shouldUseEnergyAndDrainOil) {
                    this.inputTank.drain(recipe.ingredientStack().copy(), false);
                    this.energyContainer.extract(recipe.energy(), false);
                    this.method_5431();
                }
            }
        }
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"block.stellaris.fuel_refinery");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, class_1661 inventory) {
        return new FuelRefineryMenu(containerId, inventory, (class_1263)this, this);
    }

    @Override
    public int method_5439() {
        return 6;
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.inputTank.load(tag, provider, "input");
        this.outputFuelTank.load(tag, provider, "fuel");
        this.outputDieselTank.load(tag, provider, "diesel");
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        this.inputTank.save(tag, provider, "input");
        this.outputFuelTank.save(tag, provider, "fuel");
        this.outputDieselTank.save(tag, provider, "diesel");
    }

    public SingleFluidStorage getIngredientTank() {
        return this.inputTank;
    }

    public SingleFluidStorage getOutputFuelTank() {
        return this.outputFuelTank;
    }

    public SingleFluidStorage getOutputDieselTank() {
        return this.outputDieselTank;
    }

    @Nullable
    public SingleFluidStorage getFluidTank(@Nullable class_2350 direction) {
        if (direction == null) {
            return this.inputTank;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> this.inputTank;
            case class_2350.field_11034, class_2350.field_11043 -> this.outputFuelTank;
            case class_2350.field_11039, class_2350.field_11035 -> this.outputDieselTank;
        };
    }
}

