/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fabric.fluid;

import com.fej1fun.potentials.fabric.fluid.SingleSlotFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class FabricFluidStorage
implements SlottedStorage<FluidVariant> {
    private final UniversalFluidStorage fluidStorage;

    public FabricFluidStorage(UniversalFluidStorage fluidStorage) {
        this.fluidStorage = fluidStorage;
    }

    public int getSlotCount() {
        return this.fluidStorage.getTanks();
    }

    public SingleSlotStorage<FluidVariant> getSlot(int slot) {
        return new SingleSlotFluidStorage(this.fluidStorage, slot);
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fluidStorage.fill(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)(maxAmount / 81L)), false) * 81L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fluidStorage.drain(FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)(maxAmount / 81L)), false).getAmount() * 81L;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        ArrayList<SingleSlotFluidStorage> toReturn = new ArrayList<SingleSlotFluidStorage>();
        for (int i = 0; i < this.getSlotCount(); ++i) {
            toReturn.add(new SingleSlotFluidStorage(this.fluidStorage, i));
        }
        return toReturn.iterator();
    }
}

