/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.technolith.block;

import io.netty.buffer.Unpooled;
import net.mcreator.technolith.block.entity.ConditionalGateBlockEntity;
import net.mcreator.technolith.procedures.CheckallProcedure;
import net.mcreator.technolith.procedures.RedstoneLinkEmittedRedstonePowerProcedure;
import net.mcreator.technolith.world.inventory.ConditionalGateInterfaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConditionalGateBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final IntegerProperty RED = IntegerProperty.create((String)"red", (int)0, (int)2);
    public static final IntegerProperty PINK = IntegerProperty.create((String)"pink", (int)0, (int)2);
    public static final IntegerProperty YELLOW = IntegerProperty.create((String)"yellow", (int)0, (int)2);
    public static final IntegerProperty GREEN = IntegerProperty.create((String)"green", (int)0, (int)2);
    public static final IntegerProperty BLUE = IntegerProperty.create((String)"blue", (int)0, (int)2);
    public static final IntegerProperty GREY = IntegerProperty.create((String)"grey", (int)0, (int)2);

    public ConditionalGateBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.NETHERITE_BLOCK).strength(6.0f, 40.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 1;
                }
                return 0;
            }
        }.getLightLevel()).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)RED, (Comparable)Integer.valueOf(0))).setValue((Property)PINK, (Comparable)Integer.valueOf(0))).setValue((Property)YELLOW, (Comparable)Integer.valueOf(0))).setValue((Property)GREEN, (Comparable)Integer.valueOf(0))).setValue((Property)BLUE, (Comparable)Integer.valueOf(0))).setValue((Property)GREY, (Comparable)Integer.valueOf(0)));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ConditionalGateBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{RED, PINK, YELLOW, GREEN, BLUE, GREY, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)RED, (Comparable)Integer.valueOf(0))).setValue((Property)PINK, (Comparable)Integer.valueOf(0))).setValue((Property)YELLOW, (Comparable)Integer.valueOf(0))).setValue((Property)GREEN, (Comparable)Integer.valueOf(0))).setValue((Property)BLUE, (Comparable)Integer.valueOf(0))).setValue((Property)GREY, (Comparable)Integer.valueOf(0));
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        Level world = (Level)blockAccess;
        return (int)RedstoneLinkEmittedRedstonePowerProcedure.execute(blockstate);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 2);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        CheckallProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        world.scheduleTick(pos, (Block)this, 2);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Conditional Gate");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new ConditionalGateInterfaceMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ConditionalGateBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ConditionalGateBlockEntity) {
                ConditionalGateBlockEntity be = (ConditionalGateBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof ConditionalGateBlockEntity) {
            ConditionalGateBlockEntity be = (ConditionalGateBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

