/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.technolith.network;

import java.util.HashMap;
import net.mcreator.technolith.TechnolithMod;
import net.mcreator.technolith.procedures.ChangeCheckBlueProcedure;
import net.mcreator.technolith.procedures.ChangeCheckGreenProcedure;
import net.mcreator.technolith.procedures.ChangeCheckGreyProcedure;
import net.mcreator.technolith.procedures.ChangeCheckPinkProcedure;
import net.mcreator.technolith.procedures.ChangeCheckRedProcedure;
import net.mcreator.technolith.procedures.ChangeCheckYellowProcedure;
import net.mcreator.technolith.world.inventory.ConditionalGateInterfaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ConditionalGateInterfaceButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConditionalGateInterfaceButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"technolith", (String)"conditional_gate_interface_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConditionalGateInterfaceButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new ConditionalGateInterfaceButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ConditionalGateInterfaceButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(ConditionalGateInterfaceButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                ConditionalGateInterfaceButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = ConditionalGateInterfaceMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ChangeCheckGreyProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            ChangeCheckBlueProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ChangeCheckGreenProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            ChangeCheckPinkProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            ChangeCheckRedProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            ChangeCheckYellowProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TechnolithMod.addNetworkMessage(TYPE, STREAM_CODEC, ConditionalGateInterfaceButtonMessage::handleData);
    }
}

