/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath;

import com.mojang.logging.LogUtils;
import mod.crabmod.hotbath.fluid_details.HotbathFluidType;
import mod.crabmod.hotbath.item.ItemGroup;
import mod.crabmod.hotbath.registers.BlocksRegister;
import mod.crabmod.hotbath.registers.FluidsRegister;
import mod.crabmod.hotbath.registers.ItemRegister;
import mod.crabmod.hotbath.registers.ParticleRegister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="hotbath")
public class HotBath {
    public static final String MOD_ID = "hotbath";
    private static final Logger LOGGER = LogUtils.getLogger();

    public HotBath(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ItemGroup.register(modEventBus);
        ItemRegister.register(modEventBus);
        BlocksRegister.register(modEventBus);
        FluidsRegister.register(modEventBus);
        ParticleRegister.register(modEventBus);
        HotbathFluidType.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ItemGroup.HOT_BATH_TAB.get()) {
            event.accept(ItemRegister.HERBAL_BATH_BUCKET);
            event.accept(ItemRegister.HONEY_BATH_BUCKET);
            event.accept(ItemRegister.HOT_WATER_BUCKET);
            event.accept(ItemRegister.MILK_BATH_BUCKET);
            event.accept(ItemRegister.PEONY_BATH_BUCKET);
            event.accept(ItemRegister.ROSE_BATH_BUCKET);
            event.accept(ItemRegister.BATH_HERB);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="hotbath", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLOWING.get()), (RenderType)RenderType.translucent());
        }
    }
}

