/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.advancements;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class AdvancementTrigger
implements CriterionTrigger<Instance> {
    private final Map<PlayerAdvancements, CriterionTrigger.Listener> listeners = new HashMap<PlayerAdvancements, CriterionTrigger.Listener>();
    private final ResourceLocation ID;

    public AdvancementTrigger(String modName, String advancementName) {
        this.ID = ResourceLocation.fromNamespaceAndPath((String)modName, (String)advancementName);
    }

    public void addPlayerListener(@NotNull PlayerAdvancements playerAdvancements, @NotNull CriterionTrigger.Listener listener) {
        this.listeners.put(playerAdvancements, listener);
    }

    public void removePlayerListener(@NotNull PlayerAdvancements playerAdvancements, @NotNull CriterionTrigger.Listener listener) {
        this.listeners.remove(playerAdvancements);
    }

    public void removePlayerListeners(@NotNull PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public void trigger(ServerPlayer player) {
        CriterionTrigger.Listener listener = this.listeners.get(player.getAdvancements());
        if (listener != null) {
            listener.run(player.getAdvancements());
        }
    }

    @NotNull
    public Codec<Instance> codec() {
        return Codec.unit(() -> new Instance(this.ID));
    }

    public static class Instance
    implements CriterionTriggerInstance {
        private final ResourceLocation id;

        public Instance(ResourceLocation id) {
            this.id = id;
        }

        public void validate(@NotNull CriterionValidator validator) {
        }
    }
}

