/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.events;

import mod.crabmod.hotbath.fluid_blocks.AbstractHotbathBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class FishingPreventionHandler {
    private static BlockPos lastFishingRodPosition = null;

    @SubscribeEvent
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.getItem() instanceof FishingRodItem) {
            HitResult rayTraceResult = event.getEntity().pick(5.0, 1.0f, true);
            Level world = event.getLevel();
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                Vec3 hitVec = rayTraceResult.getLocation();
                lastFishingRodPosition = new BlockPos((int)Math.round(hitVec.x), (int)Math.round(hitVec.y), (int)Math.round(hitVec.z));
            }
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Level world;
        boolean isHotBathBlock;
        if (lastFishingRodPosition != null && (isHotBathBlock = (world = event.getEntity().getCommandSenderWorld()).getBlockState(lastFishingRodPosition).getBlock() instanceof AbstractHotbathBlock)) {
            event.setCanceled(true);
        }
    }
}

