/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.events.enter_fluid_events;

import mod.crabmod.hotbath.util.CustomFluidHandler;
import mod.crabmod.hotbath.util.EffectRemovalHandler;
import mod.crabmod.hotbath.util.HealthRegenHandler;
import mod.crabmod.hotbath.util.HungerRegenHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HoneyBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HONEY_BATH_STAYED_TIME = "HoneyBathStayedTime";
    private static final int HONEY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHoneyBathEvents(LivingEvent.LivingTickEvent event) {
        HoneyBathEvents.enterFluidEvents(event, 15, HONEY_BATH_STAYED_TIME);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int stayedEffectTriggerTime, String honeyBathStayedTime) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInHoneyBath = CustomFluidHandler.isPlayerInHoneyBathBlock((Player)player);
            if (isInHoneyBath && player.isAlive()) {
                int honeyBathTime = playerData.getInt(honeyBathStayedTime) + 1;
                playerData.putInt(honeyBathStayedTime, honeyBathTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                HungerRegenHandler.regenHunger(1, 4.0f, player);
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0, false, false, true));
                if (playerData.getInt(honeyBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptSlowAndUnluck(player);
                    player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 400, 1, false, false, true));
                }
            } else {
                playerData.putInt(honeyBathStayedTime, 0);
            }
        }
    }
}

