/*
 * Decompiled with CFR 0.152.
 */
package mod.crabmod.hotbath.events.enter_fluid_events;

import java.util.Objects;
import mod.crabmod.hotbath.util.CustomFluidHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HotWaterEvents {
    private static final int TICK_NUMBER = 20;
    static final String HOT_WATER_ENTERED_NUMBER = "HotWaterEnteredNumber";
    static final String HOT_WATER_STAYED_TIME = "HotWaterStayedTime";
    static final String HAS_ENTERED_HOT_WATER = "HasEnteredHotWater";
    static final String HOT_WATER_ADVANCEMENT_ID = "hotbath:foot_health";
    private static final int HOT_WATER_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HOT_WATER_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHotWaterEvents(LivingEvent.LivingTickEvent event) {
        HotWaterEvents.enterFluidEvents(event, 100, 15, HOT_WATER_ENTERED_NUMBER, HOT_WATER_STAYED_TIME, HAS_ENTERED_HOT_WATER, HOT_WATER_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingTickEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String hotWaterEnteredNumber, String hotWaterStayedTime, String hasEnteredHotWater, String hotWaterAdvancementId) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CompoundTag playerData = player.getPersistentData();
            boolean isInHotWater = CustomFluidHandler.isPlayerInHotWaterBlock((Player)player);
            if (isInHotWater && player.isAlive()) {
                if (!playerData.getBoolean(hasEnteredHotWater)) {
                    AdvancementHolder advancement;
                    int enteredCount = playerData.getInt(hotWaterEnteredNumber) + 1;
                    playerData.putInt(hotWaterEnteredNumber, enteredCount);
                    playerData.putBoolean(hasEnteredHotWater, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = Objects.requireNonNull(player.getServer()).getAdvancements().get(Objects.requireNonNull(ResourceLocation.tryParse((String)hotWaterAdvancementId)))) != null) {
                        player.getAdvancements().award(advancement, "code_triggered");
                        playerData.putInt(hotWaterEnteredNumber, 0);
                    }
                }
                int hotBathTime = playerData.getInt(hotWaterStayedTime) + 1;
                playerData.putInt(hotWaterStayedTime, hotBathTime);
                if (playerData.getInt(hotWaterStayedTime) >= stayedEffectTriggerTime * 20) {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0, false, false, true));
                }
            } else {
                playerData.putInt(hotWaterStayedTime, 0);
                playerData.putBoolean(hasEnteredHotWater, false);
            }
        }
    }
}

